/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.util.StringTokenizer;
import java.util.Vector;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.AttributeSeries;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.Tag;

public class TagExtractor {
    String input = null;
    boolean inTag = false;
    char curCh;
    int idx = 0;
    Vector tagList = new Vector();
    boolean withText = false;

    public Vector parsePage(String input) {
        this.input = input;
        this.curCh = input.charAt(0);
        String text = null;
        while (this.idx < input.length()) {
            if (this.startTag()) {
                this.inTag = true;
                this.nextChar();
                this.tagFound(this.getTag());
                this.inTag = false;
            } else {
                text = this.getText();
                if (!text.trim().equals("")) {
                    this.textFound(text);
                }
            }
            this.nextChar();
        }
        return this.tagList;
    }

    public void nextChar() {
        ++this.idx;
        if (this.idx < this.input.length() - 1) {
            this.curCh = this.input.charAt(this.idx);
        }
    }

    public void previousChar() {
        if (this.idx > 0) {
            --this.idx;
            this.curCh = this.input.charAt(this.idx);
        }
    }

    public boolean startTag() {
        return !this.inTag && this.curCh == '<';
    }

    public boolean endTag() {
        return this.inTag && this.curCh == '>';
    }

    public String getTag() {
        StringBuffer buffer = new StringBuffer();
        while (!this.endTag() && this.idx < this.input.length() - 1) {
            buffer.append(this.curCh);
            this.nextChar();
        }
        return buffer.toString();
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        while (!this.startTag() && this.idx < this.input.length()) {
            buffer.append(this.curCh);
            this.nextChar();
        }
        if (this.startTag()) {
            this.previousChar();
        }
        return buffer.toString();
    }

    public void tagFound(String tag) {
        String tagName = TagExtractor.getTagName(tag);
        if (tagName.trim().startsWith("?")) {
            this.tagList.add(new Tag(tag.trim(), true, null));
        } else if (tagName.trim().startsWith("!--")) {
            this.tagList.add(new Tag(tag.trim(), true, null));
        } else if (tagName.trim().startsWith("!")) {
            this.tagList.add(new Tag(tag.trim(), true, null));
        } else {
            AttributeSeries attr = TagExtractor.getAttributes(tagName, tag);
            this.tagList.add(new Tag(tagName, tag.trim().lastIndexOf("/") == tag.trim().length() - 1 || tag.trim().startsWith("/"), attr.getVector()));
        }
    }

    public void textFound(String text) {
        if (this.withText) {
            this.tagList.add(new StringConcept(text));
        }
    }

    public static String getTagName(String tag) {
        int idx;
        String result = "";
        int start = 0;
        if ((tag = tag.trim()).startsWith("/")) {
            start = 1;
        }
        if (Character.isLetter(tag.charAt(idx = start))) {
            int endidx = tag.indexOf(" ", idx);
            if (endidx == -1) {
                endidx = tag.indexOf("\t", idx);
            }
            if (endidx == -1) {
                endidx = tag.indexOf("\r\n", idx);
            }
            if (endidx == -1) {
                endidx = tag.indexOf("\r", idx);
            }
            if (endidx == -1) {
                endidx = tag.indexOf("\n", idx);
            }
            if (endidx == -1) {
                endidx = tag.indexOf("/", idx);
            }
            if (endidx == -1) {
                endidx = tag.indexOf(">", idx);
            }
            if (endidx == -1) {
                endidx = tag.length();
            }
            result = tag.substring(idx, endidx);
        } else {
            result = tag.trim();
        }
        return result;
    }

    public static AttributeSeries getAttributes(String tagName, String tag) {
        StringTokenizer tokenizer = new StringTokenizer(tag, " \t\r\n><");
        String currentToken = null;
        Vector<AttributeConcept> result = new Vector<AttributeConcept>();
        while (tokenizer.hasMoreTokens()) {
            String key = null;
            String value = null;
            currentToken = tokenizer.nextToken();
            if (currentToken.startsWith("/")) {
                currentToken = currentToken.substring(1);
            }
            if (currentToken.toLowerCase().equals(tagName.toLowerCase()) || currentToken.equals("/") || currentToken.equals("/>") || currentToken.equals(">")) continue;
            if (currentToken.indexOf("=") != -1) {
                key = currentToken.substring(0, currentToken.indexOf("="));
                value = currentToken.substring(currentToken.indexOf("=") + 1);
                if (value.indexOf("\"") != -1 && value.lastIndexOf("\"") == value.indexOf("\"")) {
                    currentToken = null;
                    while (tokenizer.hasMoreTokens() && (currentToken = tokenizer.nextToken()).indexOf("\"") == -1) {
                        value = value + " " + currentToken;
                        currentToken = null;
                    }
                    if (currentToken != null) {
                        value = value + " " + currentToken;
                    }
                }
                value = TagExtractor.stripQuotes(value);
                result.add(new AttributeConcept(key.toLowerCase(), null, new StringConcept(value)));
                continue;
            }
            result.add(new AttributeConcept(currentToken.toLowerCase(), null, null));
        }
        return new AttributeSeries(result);
    }

    public static int eatWS(String text, int start) {
        if (start >= text.length()) {
            return start - 1;
        }
        char ch = text.charAt(start);
        int result = start;
        while (Character.isWhitespace(ch) && result < text.length() - 1) {
            ch = text.charAt(++result);
        }
        if (result == start) {
            return start - 1;
        }
        return result;
    }

    public static String stripQuotes(String src) {
        int t;
        int h = src.indexOf(34);
        if (h == -1) {
            h = src.indexOf(39);
        }
        if ((t = src.lastIndexOf(34)) == -1) {
            t = src.lastIndexOf(39);
        }
        if (h == -1 || t == -1) {
            return src;
        }
        if (h + 1 >= src.length()) {
            return src;
        }
        return src.substring(h + 1, t);
    }

    public TagExtractor() {
    }

    public TagExtractor(String input, boolean withText) {
        this.input = input;
        this.withText = withText;
    }
}

