/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.media.mn8.mn8Interpreter;

public class TagStriper {
    private static final int BLOCK_SIZE = 8096;
    private static final Hashtable ENTITY = TagStriper.getEntities();
    private static URL DEFAULT_URL = null;
    private static int REQUEST_NR = 1;
    private static int DEPTH = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : java TagSriper URL [ reqNr [ depth ] ] ");
            System.out.println("   - URL, URL to HTML page for striping");
            System.out.println("   - reqNr, number of requests that will be called recursively");
            System.out.println("   - depth, is access level in HTML document for links");
            System.exit(1);
        }
        if (args.length > 1) {
            try {
                REQUEST_NR = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.err.println("reqNr argument: '" + args[1] + "' isn't a number.");
                System.exit(1);
            }
            if (args.length > 2) {
                try {
                    DEPTH = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    System.err.println("depth argument: '" + args[2] + "' isn't a number.");
                    System.exit(1);
                }
            }
        }
        try {
            DEFAULT_URL = new URL(args[0]);
        }
        catch (Exception e) {
            System.err.println("Error : " + e.getMessage());
            System.exit(1);
        }
        TagStriper.showLinksRecursively(DEFAULT_URL, 1, 0);
    }

    private static final int showLinksRecursively(URL url, int level, int reqNr) {
        String TEXT = "";
        if (reqNr < REQUEST_NR && level <= DEPTH) {
            try {
                URLConnection uc = url.openConnection();
                TEXT = TagStriper.readData(uc.getInputStream());
                if (TEXT == null) {
                    System.err.println("I/O error: " + url.toString() + " can't be readed.");
                }
                System.out.println("   URL: " + url.toString());
                System.out.println(" Level: " + level);
                System.out.println(" REQNR: " + (reqNr + 1));
                System.out.println("C.TYPE: " + uc.getContentType());
                System.out.println(mn8Interpreter.EOL);
                Enumeration e = TagStriper.getLinks(TEXT, url).elements();
                while (e.hasMoreElements()) {
                    reqNr = TagStriper.showLinksRecursively(new URL((String)e.nextElement()), level + 1, reqNr + 1);
                    if (reqNr <= REQUEST_NR) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("Error : " + e.getMessage());
            }
        } else {
            --reqNr;
        }
        return reqNr;
    }

    private static final Vector getLinks(String page, URL url) {
        StringTokenizer st = new StringTokenizer(page, "<>", true);
        boolean isTag = false;
        Vector<String> links = new Vector<String>();
        while (st.hasMoreElements()) {
            int poz;
            int hrefPoz;
            String token = st.nextToken();
            if (token.equals("<")) {
                isTag = true;
                continue;
            }
            if (token.equals(">")) {
                isTag = false;
                continue;
            }
            if (!isTag || !token.trim().toLowerCase().startsWith("a") || (hrefPoz = token.trim().substring(2).trim().toLowerCase().indexOf("href")) == -1 || (poz = token.indexOf("=", hrefPoz)) == -1) continue;
            String link = token.substring(poz + 1).trim();
            int length = (link = link.replace('\"', ' ').replace('\'', ' ').replace('\\', ' ').trim()).indexOf(" ");
            if (length == -1) {
                length = link.length();
            }
            if ((link = link.substring(0, length)).length() <= 0) continue;
            if (link.indexOf(":") == -1) {
                link = link.startsWith("/") ? TagStriper.getURLName(DEFAULT_URL) + link : TagStriper.getURLName(url) + "/" + link;
            }
            if (link.indexOf("#") != -1) {
                link = link.substring(0, link.indexOf("#"));
            }
            links.addElement(link);
        }
        return links;
    }

    private static final String getURLName(URL url) {
        String uri = url.toString();
        if (url.getProtocol().equalsIgnoreCase("http")) {
            if (url.getFile() != null && url.getFile().trim().length() > 0) {
                uri = uri.substring(0, uri.lastIndexOf("/"));
            }
        } else if (url.getProtocol().equalsIgnoreCase("file") && new File(url.getPath()).isFile()) {
            uri = uri.substring(0, uri.lastIndexOf(File.separator));
        }
        return uri;
    }

    public static String strip_tags(String str, boolean showLink) {
        StringBuffer sb = new StringBuffer();
        StringBuffer entity = null;
        StringBuffer tag = null;
        boolean isTag = false;
        boolean isEntity = false;
        boolean isLink = false;
        Vector<String> links = new Vector<String>();
        int linkNr = 0;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '<' && !isTag) {
                isTag = true;
                isEntity = false;
                tag = new StringBuffer();
                tag.append(ch);
            } else if (isTag && !Character.isWhitespace(ch)) {
                String tagName;
                int poz;
                int hrefPoz;
                tag.append(ch);
                if (tag.toString().startsWith("<!--") && tag.toString().endsWith("-->")) {
                    isTag = false;
                } else if (tag.toString().startsWith("<!") && tag.toString().endsWith(">")) {
                    isTag = false;
                } else if (tag.toString().endsWith(">") && !tag.toString().startsWith("<!--")) {
                    isTag = false;
                }
                if (!isTag && showLink && tag.toString().toUpperCase().startsWith("<A") && (hrefPoz = tag.substring(2).trim().toUpperCase().indexOf("HREF")) != -1 && (poz = tag.toString().indexOf("=", hrefPoz)) != -1) {
                    String link = tag.substring(poz + 1).trim();
                    int length = (link = link.replace('\"', ' ').replace('\'', ' ').replace('\\', ' ').trim()).indexOf(" ");
                    if (length == -1) {
                        length = link.length();
                    }
                    if ((link = link.substring(0, length)).length() > 0) {
                        links.addElement("[" + ++linkNr + "] " + link);
                        isLink = true;
                    }
                }
                if (!isTag && showLink && tag.toString().toUpperCase().startsWith("</A") && isLink && tag.substring(3).trim().startsWith(">")) {
                    sb.append("[" + linkNr + "]");
                    isLink = false;
                }
                if (!isTag && tag.toString().toUpperCase().startsWith("<BR")) {
                    sb.append(mn8Interpreter.EOL);
                }
                if (!isTag && tag.toString().toUpperCase().startsWith("<P") && (tagName = tag.toString().replace('<', ' ').replace('>', ' ').trim()).equalsIgnoreCase("p")) {
                    if (TagStriper.needLF(sb.toString())) {
                        sb.append(mn8Interpreter.EOL + mn8Interpreter.EOL);
                    } else {
                        sb.append(mn8Interpreter.EOL);
                    }
                }
                if (sb.toString().trim().length() > 0 && !isTag) {
                    if (tag.toString().toUpperCase().startsWith("</TD") && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                        sb.append(" ");
                    }
                    if (tag.toString().toUpperCase().startsWith("<TR") && TagStriper.needLF(sb.toString())) {
                        sb.append(mn8Interpreter.EOL);
                    }
                }
            } else if (isTag && Character.isWhitespace(ch)) {
                String tagName = tag.toString().replace('<', ' ').replace('/', ' ').trim();
                if (tagName.length() > 0) {
                    tag.append(' ');
                }
            } else if (ch == '&' && !isEntity) {
                isEntity = true;
                entity = new StringBuffer();
                entity.append(ch);
            } else if (!isTag && isEntity && !Character.isWhitespace(ch)) {
                entity.append(ch);
                if (ch == ';' && isEntity) {
                    String res = (String)ENTITY.get(entity.toString());
                    isEntity = false;
                    if (res != null) {
                        sb.append(res);
                    }
                }
            } else if (!isEntity || !Character.isWhitespace(ch)) {
                char c;
                if (!isTag && !isEntity && ch != '\n') {
                    c = '\u0000';
                    if (sb.length() > 0) {
                        c = sb.charAt(sb.length() - 1);
                    }
                    if (!Character.isWhitespace(ch)) {
                        sb.append(ch);
                    } else if (!Character.isWhitespace(c) && sb.length() > 0) {
                        sb.append(' ');
                    }
                }
                if (!(isTag || isEntity || ch != '\n' || sb.length() <= 0 || Character.isWhitespace(c = sb.charAt(sb.length() - 1)))) {
                    sb.append(' ');
                }
            }
            ++i;
        }
        if (showLink && linkNr > 0) {
            sb.append(mn8Interpreter.EOL + mn8Interpreter.EOL);
            Enumeration e = links.elements();
            while (e.hasMoreElements()) {
                sb.append((String)e.nextElement() + mn8Interpreter.EOL);
            }
        }
        return sb.toString();
    }

    private static final boolean needLF(String str) {
        boolean foundLF = false;
        int i = str.length() - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (!Character.isWhitespace(ch)) break;
            if (ch == '\n') {
                foundLF = true;
                break;
            }
            --i;
        }
        return !foundLF;
    }

    private static final String readData(InputStream is) {
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[8096];
        int size = 0;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((size = reader.read(buffer, 0, 8096)) != -1) {
                sb.append(new String(buffer, 0, size));
            }
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    private static final Hashtable getEntities() {
        Hashtable<String, String> entity = new Hashtable<String, String>();
        entity.put("&nbsp;", " ");
        entity.put("&quot;", "\"");
        entity.put("&amp;", "&");
        entity.put("&lt;", "<");
        entity.put("&gt;", ">");
        entity.put("&aacute;", "a");
        entity.put("&Aacute;", "A");
        entity.put("&eacute;", "e");
        entity.put("&Eacute;", "E");
        entity.put("&iacute;", "i");
        entity.put("&Iacute;", "I");
        entity.put("&oacute;", "o");
        entity.put("&Oacute;", "O");
        entity.put("&uacute;", "u");
        entity.put("&Uacute;", "U");
        entity.put("&ouml;", "o");
        entity.put("&Ouml;", "O");
        entity.put("&uuml;", "u");
        entity.put("&Uuml;", "U");
        entity.put("&otilde;", "o");
        entity.put("&Otilde;", "O");
        entity.put("&utilde;", "u");
        entity.put("&Utilde;", "U");
        return entity;
    }
}

