/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.util.Vector;
import org.media.mn8.protocol.http.DefaultAttributes;
import org.media.mn8.protocol.http.DefaultControl;

public class TextAreaControl
extends DefaultAttributes
implements DefaultControl {
    private static final String[] attrNames = new String[]{"name", "rows", "cols", "disabled", "readonly", "tabindex", "accesskey", "onfocus", "onblur", "onselect", "onchange"};
    private String name;
    private String rows;
    private String cols;
    private String value;
    private String attrList = "";

    public void setName(String name) {
        this.name = name;
        this.attrList = this.attrList + this.getAttrPair("name", name);
    }

    public void setRows(String row) {
        this.rows = row;
        this.attrList = this.attrList + this.getAttrPair("rows", row);
    }

    public void setCols(String col) {
        this.cols = col;
        this.attrList = this.attrList + this.getAttrPair("cols", col);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSendable() {
        return this.name != null && this.name.trim().length() > 0 && this.value != null && this.value.trim().length() > 0;
    }

    public String getName() {
        return this.name;
    }

    public Vector getValues() {
        Vector<String> result = new Vector<String>();
        result.add(this.value);
        return result;
    }

    public String toXMLString() {
        String ret = "<TEXTAREA " + this.getAttrList().trim() + ">\n";
        if (this.value != null && this.value.trim().length() > 0) {
            ret = ret + "        <![CDATA[ " + this.value.trim() + " ]]>\n";
        }
        ret = ret + "    </TEXTAREA>";
        return ret;
    }

    public String toString() {
        return "TEXTAREA : \n" + this.getAttrList().replace(' ', '\n') + "\nVALUE: " + this.value;
    }

    public void parse(String tag) {
        super.parse(tag);
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() < 1) {
            return;
        }
        int i = 0;
        while (i < attrNames.length) {
            String value = super.getValueOf(attrs, attrNames[i]);
            if (value != null) {
                if (attrNames[i].equals("name")) {
                    this.name = value;
                }
                if (attrNames[i].equals("rows")) {
                    this.rows = value;
                }
                if (attrNames[i].equals("cols")) {
                    this.cols = value;
                }
                this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
            }
            ++i;
        }
    }

    public String getAttrList() {
        return this.attrList + super.getAttrList();
    }

    public String getControlType() {
        return "TEXTAREA";
    }

    public boolean equals(DefaultControl control) {
        TextAreaControl tacontrol = (TextAreaControl)control;
        return tacontrol.name != null && tacontrol.name.equalsIgnoreCase(this.name);
    }
}

