/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.jabber;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JabberDataBlock {
    private String tagName;
    protected Vector childBlocks;
    protected StringBuffer textData = null;
    protected JabberDataBlock parent;
    protected Hashtable attributes;

    public void addChild(JabberDataBlock newData) {
        if (this.childBlocks == null) {
            this.childBlocks = new Vector();
        }
        this.childBlocks.addElement(newData);
    }

    public void addText(String text) {
        if (this.textData == null) {
            this.textData = new StringBuffer();
        }
        this.textData.append(text);
    }

    public JabberDataBlock getParent() {
        return this.parent;
    }

    public byte[] getBytes() {
        String data = this.toString();
        return data.getBytes();
    }

    public String getText() {
        return this.textData.toString();
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, String value) {
        if (attributeName == null || value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(attributeName, value);
    }

    public Vector getChildBlocks() {
        return this.childBlocks;
    }

    public String toString() {
        String tagStart = this.getTagStart();
        StringBuffer data = new StringBuffer(tagStart);
        if (this.textData != null) {
            String text = this.textData.toString();
            data.append(this.textData);
        }
        if (this.childBlocks != null) {
            Enumeration e = this.childBlocks.elements();
            while (e.hasMoreElements()) {
                JabberDataBlock thisBlock = (JabberDataBlock)e.nextElement();
                data.append(thisBlock.toString());
            }
        }
        String endTag = this.getTagEnd();
        data.append(endTag);
        return data.toString();
    }

    protected void addAttributeToStringBuffer(StringBuffer buffer) {
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String nextKey = (String)e.nextElement();
            String nextValue = (String)this.attributes.get(nextKey);
            buffer.append(' ');
            buffer.append(nextKey);
            buffer.append("=\"");
            buffer.append(nextValue);
            buffer.append('\"');
        }
    }

    public String getTagStart() {
        StringBuffer tagStart = new StringBuffer("<");
        tagStart.append(this.getTagName());
        if (this.attributes != null) {
            this.addAttributeToStringBuffer(tagStart);
        }
        tagStart.append('>');
        return tagStart.toString();
    }

    public String getTagEnd() {
        StringBuffer end = new StringBuffer("</");
        end.append(this.getTagName());
        end.append('>');
        return end.toString();
    }

    public String getTagName() {
        return this.tagName;
    }

    protected void constructReply(JabberDataBlock container) {
        String messageType;
        String thisID;
        String thisFrom = this.getAttribute("from");
        if (thisFrom != null) {
            container.setAttribute("to", thisFrom);
        }
        if ((thisID = this.getAttribute("id")) != null) {
            container.setAttribute("id", thisID);
        }
        if ((messageType = this.getAttribute("type")) != null) {
            container.setAttribute("type", messageType);
        }
    }

    public JabberDataBlock() {
        this("unknown", null, null);
    }

    public JabberDataBlock(JabberDataBlock _parent) {
        this("unknown", _parent, null);
    }

    public JabberDataBlock(JabberDataBlock _parent, Hashtable _attributes) {
        this("unknown", _parent, _attributes);
    }

    public JabberDataBlock(String _tagName, JabberDataBlock _parent, Hashtable _attributes) {
        this.parent = _parent;
        this.attributes = _attributes;
        this.tagName = _tagName;
    }
}

