/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.jabber;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.media.mn8.protocol.jabber.ConnectorInterface;
import org.media.mn8.protocol.jabber.JabberDataBlock;
import org.media.mn8.protocol.jabber.JabberDataBlockDispatcher;
import org.media.mn8.protocol.jabber.JabberListener;
import org.media.mn8.protocol.jabber.datablocks.Iq;
import org.media.mn8.protocol.jabber.datablocks.Message;
import org.media.mn8.protocol.jabber.datablocks.Presence;
import org.media.mn8.protocol.jabber.xmlparser.XMLEventListener;
import org.media.mn8.protocol.jabber.xmlparser.XMLParser;

public class JabberStream
implements XMLEventListener,
Runnable {
    private OutputStream outStream;
    private InputStream inpStream;
    private JabberDataBlockDispatcher dispatcher = new JabberDataBlockDispatcher();
    private JabberDataBlock currentBlock;

    public void open(ConnectorInterface connectorInterface) throws IOException {
        this.outStream = connectorInterface.openOutputStream();
        this.inpStream = connectorInterface.openInputStream();
        StringBuffer streamInitiator = new StringBuffer("<stream:stream to=\"");
        String hostname = connectorInterface.getHostname();
        streamInitiator.append(hostname);
        streamInitiator.append("\" xmlns=\"jabber:client\" xmlns:stream=\"http://etherx.jabber.org/streams\">");
        this.outStream.write(streamInitiator.toString().getBytes());
        this.outStream.flush();
        Thread newThread = new Thread(this);
        newThread.start();
    }

    public void run() {
        try {
            XMLParser parser = new XMLParser(this);
            DataInputStream dis = new DataInputStream(this.inpStream);
            parser.setInputUTF8Encoded(true);
            parser.parse(dis);
            this.dispatcher.broadcastTerminatedConnection(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dispatcher.broadcastTerminatedConnection(e);
        }
    }

    public void close() {
        this.dispatcher.setJabberListener(null);
        try {
            try {
                this.send("</stream:stream>");
                this.inpStream.close();
                this.outStream.close();
            }
            catch (IOException iOException) {
                Object var2_2 = null;
                this.dispatcher.halt();
            }
            Object var2_1 = null;
            this.dispatcher.halt();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dispatcher.halt();
            throw throwable;
        }
    }

    public void send(byte[] data) throws IOException {
        this.outStream.write(data);
        this.outStream.flush();
    }

    public void send(String data) throws IOException {
        this.send(data.getBytes());
    }

    public void send(JabberDataBlock block) throws IOException {
        this.send(block.getBytes());
    }

    public void setJabberListener(JabberListener listener) {
        this.dispatcher.setJabberListener(listener);
    }

    public void tagStarted(String name, Hashtable attributes) {
        if (name.equals("stream:stream")) {
            this.dispatcher.broadcastBeginConversation();
        } else {
            this.currentBlock = name.equals("message") ? new Message(this.currentBlock, attributes) : (name.equals("iq") ? new Iq(this.currentBlock, attributes) : (name.equals("presence") ? new Presence(this.currentBlock, attributes) : new JabberDataBlock(name, this.currentBlock, attributes)));
        }
    }

    public void plaintextEncountered(String text) {
        if (this.currentBlock != null) {
            this.currentBlock.addText(text);
        }
    }

    public void tagEnded(String name) {
        if (this.currentBlock == null) {
            return;
        }
        JabberDataBlock parent = this.currentBlock.getParent();
        if (parent == null) {
            this.dispatcher.broadcastJabberDataBlock(this.currentBlock);
        } else {
            parent.addChild(this.currentBlock);
        }
        this.currentBlock = parent;
    }

    public JabberStream(ConnectorInterface connectorInterface) throws IOException {
        this(connectorInterface, null, true);
    }

    public JabberStream(ConnectorInterface connectorInterface, JabberListener theListener) throws IOException {
        this(connectorInterface, theListener, true);
    }

    public JabberStream(ConnectorInterface connectorInterface, JabberListener theListener, boolean connect) throws IOException {
        if (theListener != null) {
            this.setJabberListener(theListener);
        }
        if (connect) {
            this.open(connectorInterface);
        }
    }
}

