/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.jabber.datablocks;

import java.util.Hashtable;
import org.media.mn8.protocol.jabber.JabberDataBlock;

public class Message
extends JabberDataBlock {
    public void setBodyText(String text) {
        JabberDataBlock body = new JabberDataBlock("body", null, null);
        body.addText(text);
        this.addChild(body);
    }

    public void setHTMLBodyText(String html) {
        JabberDataBlock body = new JabberDataBlock("html", null, null);
        body.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        body.addText(html);
        this.addChild(body);
    }

    public void setThread(String text) {
        JabberDataBlock thread = new JabberDataBlock("thread", null, null);
        thread.addText(text);
        this.addChild(thread);
    }

    public void setSubject(String text) {
        JabberDataBlock subject = new JabberDataBlock("subject", null, null);
        subject.addText(text);
        this.addChild(subject);
    }

    private final String getTextForChildBlock(String blockname) {
        if (this.childBlocks == null) {
            return "";
        }
        int i = 0;
        while (i < this.childBlocks.size()) {
            JabberDataBlock thisBlock = (JabberDataBlock)this.childBlocks.elementAt(i);
            if (thisBlock.getTagName().equals(blockname)) {
                return thisBlock.getText();
            }
            ++i;
        }
        return "";
    }

    public String getSubject() {
        return this.getTextForChildBlock("subject");
    }

    public String getBody() {
        return this.getTextForChildBlock("body");
    }

    public Message constructReply() {
        if (this.attributes == null) {
            return null;
        }
        Message reply = new Message();
        super.constructReply(reply);
        String thread = this.getTextForChildBlock("thread");
        if (thread != null && thread.length() > 0) {
            this.setThread(thread);
        }
        return reply;
    }

    public String getTagName() {
        return "message";
    }

    public Message(String to, String message) {
        if (to != null) {
            this.setAttribute("to", to);
        }
        if (message != null) {
            this.setBodyText(message);
        }
    }

    public Message(String to) {
        this(to, null);
    }

    public Message() {
        this((String)null);
    }

    public Message(JabberDataBlock _parent, Hashtable _attributes) {
        super(_parent, _attributes);
    }
}

