/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.jabber.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import org.media.mn8.protocol.jabber.xmlparser.EndOfXMLException;
import org.media.mn8.protocol.jabber.xmlparser.ReadEndChecker;
import org.media.mn8.protocol.jabber.xmlparser.XMLEventListener;

public class XMLParser {
    private Reader inputReader;
    private XMLEventListener eventHandler;
    private String rootTag = null;
    private boolean isUTF8Encoded;
    private StringBuffer dataBuffer;
    private InputStream is;
    private final InPlaintextReadEndChecker inPlaintextReadEndChecker = new InPlaintextReadEndChecker();
    private final InTagReadEndChecker inTagReadEndChecker = new InTagReadEndChecker();

    private final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void setInputUTF8Encoded(boolean flag) {
        this.isUTF8Encoded = flag;
    }

    public int getNextCharacter() throws IOException {
        int actualValue = -1;
        int inputValue = this.inputReader.read();
        if (inputValue == -1) {
            return -1;
        }
        if (!this.isUTF8Encoded) {
            actualValue = inputValue;
        } else if (((inputValue &= 0xFF) & 0x80) == 0) {
            actualValue = inputValue;
        } else if ((inputValue & 0xF8) == 240) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        } else if ((inputValue & 0xF0) == 224) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        } else if ((inputValue & 0xE0) == 192) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        }
        return actualValue;
    }

    /*
     * Unable to fully structure code
     */
    private final String readUntilEnd(ReadEndChecker checker) throws IOException, EndOfXMLException {
        data = new StringBuffer();
        nextChar = this.getNextCharacter();
        if (nextChar != -1) ** GOTO lbl8
        throw new EndOfXMLException();
lbl-1000:
        // 1 sources

        {
            data.append((char)nextChar);
            nextChar = this.getNextCharacter();
lbl8:
            // 2 sources

            ** while (nextChar != -1 && !checker.shouldStop((int)nextChar))
        }
lbl9:
        // 1 sources

        if (nextChar != 60 && nextChar != 62) {
            data.append((char)nextChar);
        }
        returnData = data.toString();
        return returnData;
    }

    /*
     * Unable to fully structure code
     */
    private final Hashtable handleAttributes(String data) {
        attributes = new Hashtable<String, String>();
        length = data.length();
        i = 0;
        while (i < length) {
            nameBuffer = new StringBuffer();
            thisChar = data.charAt(i);
            while (this.isWhitespace(thisChar) && i < length) {
                thisChar = data.charAt(++i);
            }
            if (thisChar != '>' && i != length) ** GOTO lbl15
            break;
lbl-1000:
            // 1 sources

            {
                nameBuffer.append(thisChar);
                thisChar = data.charAt(++i);
lbl15:
                // 2 sources

                ** while (thisChar != '=' && i < length)
            }
lbl16:
            // 1 sources

            if (i == length) break;
            name = nameBuffer.toString();
            thisChar = data.charAt(++i);
            while (this.isWhitespace(thisChar) && i < length) {
                thisChar = data.charAt(++i);
            }
            breakOn = 0;
            if (thisChar == '\"') {
                breakOn = 1;
            } else if (thisChar == '\'') {
                breakOn = 2;
            }
            valueBuffer = new StringBuffer();
            if (breakOn == 0) {
                valueBuffer.append(thisChar);
            }
            ++i;
            while (i < length) {
                thisChar = data.charAt(i);
                ++i;
                if (breakOn == 0 && this.isWhitespace(thisChar) || breakOn == 1 && thisChar == '\"' || breakOn == 2 && thisChar == '\'') break;
                valueBuffer.append(thisChar);
            }
            value = valueBuffer.toString();
            attributes.put(name, value);
        }
        return attributes;
    }

    private final void handleTag() throws IOException, EndOfXMLException {
        boolean startTag = true;
        boolean emptyTag = false;
        boolean hasMoreData = true;
        String tagName = null;
        Hashtable attributes = null;
        String data = this.readUntilEnd(this.inTagReadEndChecker);
        if (data.startsWith("?")) {
            return;
        }
        int substringStart = 0;
        int substringEnd = data.length();
        if (data.startsWith("/")) {
            startTag = false;
            ++substringStart;
        }
        if (data.endsWith("/")) {
            emptyTag = true;
            --substringEnd;
        }
        data = data.substring(substringStart, substringEnd);
        int spaceIdx = 0;
        while (spaceIdx < data.length() && !this.isWhitespace(data.charAt(spaceIdx))) {
            ++spaceIdx;
        }
        tagName = data.substring(0, spaceIdx).toLowerCase();
        if (spaceIdx != data.length()) {
            data = data.substring(spaceIdx + 1);
            attributes = this.handleAttributes(data);
        }
        tagName = tagName.toLowerCase();
        if (startTag) {
            if (this.rootTag == null) {
                this.rootTag = tagName;
            }
            this.eventHandler.tagStarted(tagName, attributes);
        }
        if (emptyTag || !startTag) {
            this.eventHandler.tagEnded(tagName);
            if (this.rootTag != null && tagName.equals(this.rootTag)) {
                throw new EndOfXMLException();
            }
        }
    }

    private final void handlePlainText() throws IOException, EndOfXMLException {
        String data = this.readUntilEnd(this.inPlaintextReadEndChecker);
        this.eventHandler.plaintextEncountered(data);
    }

    public void parse(InputStream _is) throws IOException {
        this.is = _is;
        InputStreamReader isr = new InputStreamReader(this.is);
        this.parse(isr);
    }

    public void parse(Reader _inputReader) throws IOException {
        this.inputReader = _inputReader;
        try {
            while (true) {
                this.handlePlainText();
                this.handleTag();
            }
        }
        catch (EndOfXMLException endOfXMLException) {
            return;
        }
    }

    public XMLParser(XMLEventListener _eventHandler) {
        this.eventHandler = _eventHandler;
        this.dataBuffer = new StringBuffer();
    }

    class InPlaintextReadEndChecker
    implements ReadEndChecker {
        public boolean shouldStop(int c) {
            return c == 60;
        }

        InPlaintextReadEndChecker() {
        }
    }

    class InTagReadEndChecker
    implements ReadEndChecker {
        public boolean shouldStop(int c) {
            return c == 62;
        }

        InTagReadEndChecker() {
        }
    }
}

