/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.pop3;

import com.oroinc.net.pop3.POP3Client;
import com.oroinc.net.pop3.POP3MessageInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

class POP3URLConnection
extends URLConnection {
    private static final String DEF_HOST = "localhost";
    private static final int DEF_PORT = 110;
    private static final String DEF_USER = "guest";
    private static final String DEF_PASSWORD = "guest";
    private String host;
    private int port;
    private String user;
    private String password;
    private String command;
    private String messID = null;
    private StringBuffer result = new StringBuffer();
    private boolean connected = false;
    private URL url;

    public void connect() throws IOException {
        this.host = this.url.getHost().length() == 0 ? DEF_HOST : this.url.getHost();
        this.port = this.url.getPort() < 1 ? 110 : this.url.getPort();
        String file = this.url.getFile();
        this.command = file.equals("/") || file.trim().length() < 1 ? "retrieve" : (file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?")));
        String ui = this.url.getUserInfo();
        if (ui == null || ui.trim().length() < 1) {
            this.user = "guest";
            this.password = "guest";
        } else {
            if (ui.indexOf(":") != -1) {
                this.user = ui.substring(0, ui.indexOf(":"));
                this.password = ui.substring(ui.indexOf(":") + 1);
            } else {
                this.user = ui;
                this.password = "guest";
            }
            if (this.user.trim().length() < 1) {
                this.user = "guest";
            }
            if (this.password.trim().length() < 1) {
                this.password = "guest";
            }
        }
        String qu = this.url.getQuery();
        if (qu != null && qu.indexOf("=") < 0) {
            throw new IOException("\nThe query structure is: ?id=messID\n");
        }
        if (qu.trim().length() != 0) {
            this.messID = qu.substring(qu.indexOf("=") + 1);
        }
        this.getConnection(this.host, this.port, this.user, this.password, this.command, this.messID);
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ByteArrayInputStream(this.result.toString().getBytes());
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessageID() {
        return this.messID;
    }

    private final void getConnection(String host, int port, String user, String password, String command, String messID) throws IOException {
        POP3Client client = new POP3Client();
        try {
            client.connect(host, port);
            if (!client.login(user, password)) {
                throw new IOException("Authentification failed.");
            }
            this.connected = true;
            if (command.equalsIgnoreCase("list")) {
                if (messID != null) {
                    POP3MessageInfo info = client.listMessage(new Integer(messID).intValue());
                    if (info != null) {
                        this.result.append(info.number + " (" + info.size + ")\n");
                    }
                } else {
                    POP3MessageInfo[] info = client.listMessages();
                    if (info != null) {
                        int i = 0;
                        while (i < info.length) {
                            this.result.append(info[i].number + " (" + info[i].size + ")\n");
                            ++i;
                        }
                    }
                }
                return;
            }
            if (command.equalsIgnoreCase("delete")) {
                if (messID != null) {
                    if (client.deleteMessage(new Integer(messID).intValue())) {
                        this.result.append(messID + " message is deleted.\n");
                    } else {
                        this.result.append("Unable to delete message " + messID + ".\n");
                    }
                } else {
                    POP3MessageInfo[] info = client.listMessages();
                    boolean allDeleted = true;
                    if (info == null) {
                        return;
                    }
                    int i = 0;
                    while (i < info.length) {
                        if (!client.deleteMessage(info[i].number)) {
                            allDeleted = false;
                        }
                        ++i;
                    }
                    if (allDeleted) {
                        this.result.append("All messages is deleted.\n");
                    } else {
                        this.result.append("Can't delete all messages.\n");
                    }
                }
                return;
            }
            if (command.equalsIgnoreCase("retrieve")) {
                if (messID != null) {
                    try {
                        this.result.append(this.getMessage(client.retrieveMessage(new Integer(messID).intValue())));
                    }
                    catch (Exception ex) {
                        this.result.append("Unable to read message " + messID + ".\n");
                    }
                } else {
                    POP3MessageInfo[] info = client.listMessages();
                    if (info != null) {
                        int i = 0;
                        while (i < info.length) {
                            try {
                                this.result.append(this.getMessage(client.retrieveMessage(info[i].number)) + "\n");
                            }
                            catch (Exception ex) {
                                this.result.append("Unable to read message " + info[i].number + ".\n");
                            }
                            ++i;
                        }
                    }
                }
                return;
            }
            throw new IOException("Unknown command: " + command + ". Command must be: list, delete or retrieve.");
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private final String getMessage(Reader rd) throws Exception {
        BufferedReader reader = new BufferedReader(rd);
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        reader.close();
        return sb.toString();
    }

    POP3URLConnection(URL getURL) {
        super(getURL);
        try {
            this.url = new URL(URLDecoder.decode(getURL.toString()));
        }
        catch (Exception e) {
            System.out.println("Can't decode the URL: " + getURL.toString());
        }
    }
}

