/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.smtp;

import com.oroinc.net.smtp.SMTPClient;
import com.oroinc.net.smtp.SMTPReply;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

class SMTPURLConnection
extends URLConnection {
    private static final String DEF_HOST = "localhost";
    private static final int DEF_PORT = 25;
    private String host;
    private int port;
    private boolean connected = false;
    private URL url;

    public void connect() throws IOException {
        this.host = this.url.getHost().length() == 0 ? DEF_HOST : this.url.getHost();
        this.port = this.url.getPort() < 1 ? 25 : this.url.getPort();
        this.getConnection(this.host, this.port);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ByteArrayOutputStream();
    }

    private final void getConnection(String host, int port) throws IOException {
        SMTPClient client = new SMTPClient();
        try {
            client.connect(host, port);
            if (!SMTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                client.disconnect();
                throw new IOException("SMTP server refused connection.");
            }
            if (!client.login()) {
                throw new IOException("Login failed");
            }
        }
        catch (IOException e) {
            if (client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw new IOException("Could not connect to server.");
        }
        this.connected = true;
    }

    SMTPURLConnection(URL getURL) {
        super(getURL);
        try {
            this.url = new URL(URLDecoder.decode(getURL.toString()));
        }
        catch (Exception e) {
            System.out.println("Can't decode the URL: " + getURL.toString());
        }
    }
}

