/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

class XmlrpcURLConnection
extends URLConnection {
    private static final String DEF_HOST = "localhost";
    private static final int DEF_PORT = 10300;
    private static final String DEF_USER = "guest";
    private static final String DEF_PASSWORD = "guest";
    private String host;
    private int port;
    private String methodName;
    private String user;
    private String password;
    private Vector params = new Vector();
    private String paramNames = "";
    private String result = "";
    private boolean connected = false;
    private URL url;

    public void connect() throws IOException {
        this.host = this.url.getHost().length() == 0 ? DEF_HOST : this.url.getHost();
        this.port = this.url.getPort() < 1 ? 10300 : this.url.getPort();
        String file = this.url.getFile();
        if (file.equals("/") || file.trim().length() < 1) {
            throw new IOException("Missing method parameter from URL");
        }
        this.methodName = file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?"));
        if (this.methodName.indexOf(".") < 0) {
            throw new IOException("\nThe method name must contain the handler eg.:\nxmlrpc://user:password@host:port/handler.method?param1=...&param2=...&...");
        }
        String ui = this.url.getUserInfo();
        if (ui == null || ui.trim().length() < 1) {
            this.user = "guest";
            this.password = "guest";
        } else {
            if (ui.indexOf(":") != -1) {
                this.user = ui.substring(0, ui.indexOf(":"));
                this.password = ui.substring(ui.indexOf(":") + 1);
            } else {
                this.user = ui;
                this.password = "guest";
            }
            if (this.user.trim().length() < 1) {
                this.user = "guest";
            }
            if (this.password.trim().length() < 1) {
                this.password = "guest";
            }
        }
        String qu = this.url.getQuery();
        if (qu == null) {
            throw new IOException("\nYou must have query element in URL, to post parameters for handler\n");
        }
        if (qu.indexOf("=") < 0) {
            throw new IOException("\nThe query structure is: ?name1=parameter1&name2=parameter2&...\n");
        }
        if (qu.trim().length() != 0) {
            StringTokenizer pt = new StringTokenizer(qu, "&");
            try {
                while (pt.hasMoreTokens()) {
                    String t = pt.nextToken();
                    this.paramNames = this.paramNames.length() < 1 ? t.substring(0, t.indexOf("=")) : this.paramNames + ", " + t.substring(0, t.indexOf("="));
                    this.params.addElement(t.substring(t.indexOf("=") + 1));
                }
            }
            catch (Exception e) {
                throw new IOException("\nInvalid query attributes: " + qu);
            }
        } else {
            throw new IOException("\nQuery attributes in URL is missing\n");
        }
        this.getConnection(this.host, this.port, this.user, this.password, this.methodName, this.params);
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ByteArrayInputStream(this.result.getBytes());
    }

    public String getMethodName() {
        return this.methodName;
    }

    private final void getConnection(String host, int port, String user, String password, String method, Vector methodParams) throws IOException {
        String xURL = "http://" + host + ":" + port + "/";
        try {
            XmlRpcClient client = new XmlRpcClient(xURL);
            client.setBasicAuthentication(user, password);
            this.result = (String)client.execute(method, methodParams);
            this.connected = true;
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage() + "( " + this.paramNames + " )");
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    XmlrpcURLConnection(URL getURL) {
        super(getURL);
        try {
            this.url = new URL(URLDecoder.decode(getURL.toString()));
        }
        catch (Exception e) {
            System.out.println("Can't decode the URL: " + getURL.toString());
        }
    }
}

