/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.servlet;

import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.CookieConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LocaleConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.servlet.ServletRequestDefinition;
import org.media.mn8.servlet.ServletSession;

public class ServletRequestConcept
extends JavaConcept {
    protected HttpServletRequest _servletRequest = null;
    private MapConcept _headers = null;
    private MapConcept _parameters = null;
    private SeriesConcept _cookies = null;
    private SeriesConcept _locales = null;
    private ServletContext _servletContext = null;

    public StringConcept getAuthType() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getAuthType());
        }
        return new StringConcept();
    }

    public StringConcept getContextPath() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getContextPath());
        }
        return new StringConcept();
    }

    public ServletSession getSession() {
        if (this._servletRequest != null) {
            return new ServletSession(this._servletRequest.getSession());
        }
        return new ServletSession();
    }

    public ServletSession getSession(LogicalConcept create) {
        if (this._servletRequest != null) {
            return new ServletSession(this._servletRequest.getSession(create.getValue()));
        }
        return new ServletSession();
    }

    public SeriesConcept getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        SeriesConcept result = new SeriesConcept();
        if (this._servletRequest != null) {
            Cookie[] cookies = this._servletRequest.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    CookieConcept cc = new CookieConcept(new StringConcept(cookies[i].getName()), new StringConcept(cookies[i].getDomain()));
                    if (cookies[i].getDomain() != null) {
                        cc.setDomain(new StringConcept("" + cookies[i].getDomain()));
                    }
                    cc.setExpires(new StringConcept("" + cookies[i].getMaxAge()));
                    if (cookies[i].getPath() != null) {
                        cc.setPath(new StringConcept("" + cookies[i].getPath()));
                    }
                    cc.setSecure(new StringConcept("" + cookies[i].getSecure()));
                    cc.setValue(new StringConcept("" + cookies[i].getValue()));
                    result.add(cc);
                    ++i;
                }
            }
            this._cookies = result;
        }
        return result;
    }

    public SeriesConcept getLocales() {
        if (this._locales != null) {
            return this._locales;
        }
        SeriesConcept result = new SeriesConcept();
        Locale loc = null;
        if (this._servletRequest != null) {
            Enumeration locales = this._servletRequest.getLocales();
            while (locales != null && locales.hasMoreElements()) {
                loc = (Locale)locales.nextElement();
                if (loc == null) continue;
                result.add(new LocaleConcept(loc));
            }
            this._locales = result;
        }
        return result;
    }

    public StringConcept getMethod() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getMethod());
        }
        return new StringConcept();
    }

    public MapConcept getHeaders() {
        if (this._servletRequest != null) {
            if (this._headers != null) {
                return this._headers;
            }
            MapConcept result = new MapConcept();
            Enumeration headNames = this._servletRequest.getHeaderNames();
            while (headNames != null && headNames.hasMoreElements()) {
                String name = (String)headNames.nextElement();
                result.add(new StringConcept(name), new StringConcept(this._servletRequest.getHeader(name)));
            }
            this._headers = result;
            return result;
        }
        return new MapConcept();
    }

    public MapConcept getParameters() {
        if (this._servletRequest != null) {
            if (this._parameters != null) {
                return this._parameters;
            }
            MapConcept result = new MapConcept();
            Enumeration paramNames = this._servletRequest.getParameterNames();
            while (paramNames != null && paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                String[] values = this._servletRequest.getParameterValues(name);
                if (values.length > 0 && values.length < 2) {
                    result.add(new StringConcept(name), new StringConcept(values[0]));
                    continue;
                }
                SeriesConcept vals = new SeriesConcept();
                int i = 0;
                while (i < values.length) {
                    vals.add(new StringConcept(values[i]));
                    ++i;
                }
                result.add(new StringConcept(name), vals);
            }
            this._parameters = result;
            return result;
        }
        return new MapConcept();
    }

    public StringConcept getPathInfo() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getPathInfo());
        }
        return new StringConcept();
    }

    public StringConcept getPathTranslated() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getPathTranslated());
        }
        return new StringConcept();
    }

    public StringConcept getQueryString() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getQueryString());
        }
        return new StringConcept();
    }

    public StringConcept getRemoteUser() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getRemoteUser());
        }
        return new StringConcept();
    }

    public StringConcept getRequestedSessionId() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getRequestedSessionId());
        }
        return new StringConcept();
    }

    public StringConcept getRequestURI() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getRequestURI());
        }
        return new StringConcept();
    }

    public StringConcept getServletPath() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getServletPath());
        }
        return new StringConcept();
    }

    public StringConcept getCharacterEncoding() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getCharacterEncoding());
        }
        return new StringConcept();
    }

    public StringConcept getContentType() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getContentType());
        }
        return new StringConcept();
    }

    public StringConcept getProtocol() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getProtocol());
        }
        return new StringConcept();
    }

    public StringConcept getRemoteAddr() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getRemoteAddr());
        }
        return new StringConcept();
    }

    public StringConcept getRemoteHost() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getRemoteHost());
        }
        return new StringConcept();
    }

    public StringConcept getScheme() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getScheme());
        }
        return new StringConcept();
    }

    public StringConcept getServerName() {
        if (this._servletRequest != null) {
            return new StringConcept(this._servletRequest.getServerName());
        }
        return new StringConcept();
    }

    public IntegerConcept getContentLength() {
        if (this._servletRequest != null) {
            return new IntegerConcept(this._servletRequest.getContentLength());
        }
        return new IntegerConcept(-1L);
    }

    public IntegerConcept getServerPort() {
        if (this._servletRequest != null) {
            return new IntegerConcept(this._servletRequest.getServerPort());
        }
        return new IntegerConcept(-1L);
    }

    public StringConcept getUserPrincipalName() {
        if (this._servletRequest != null && this._servletRequest.getUserPrincipal() != null) {
            return new StringConcept(this._servletRequest.getUserPrincipal().getName());
        }
        return new StringConcept();
    }

    public StringConcept getRealPath(StringConcept path) {
        if (this._servletContext != null) {
            return new StringConcept(this._servletContext.getRealPath(path.toString()));
        }
        return new StringConcept();
    }

    public StringConcept getMimeType(StringConcept path) {
        if (this._servletContext != null) {
            return new StringConcept(this._servletContext.getMimeType(path.toString()));
        }
        return new StringConcept();
    }

    public StringConcept getResourceURL(StringConcept path) {
        if (this._servletContext != null) {
            try {
                return new StringConcept(this._servletContext.getResource(path.toString()).toString());
            }
            catch (Exception ex) {
                return new StringConcept();
            }
        }
        return new StringConcept();
    }

    public LogicalConcept isRequestedSessionIdFromCookie() {
        if (this._servletRequest != null) {
            return new LogicalConcept(this._servletRequest.isRequestedSessionIdFromCookie());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept isSecure() {
        if (this._servletRequest != null) {
            return new LogicalConcept(this._servletRequest.isSecure());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept isRequestedSessionIdFromURL() {
        if (this._servletRequest != null) {
            return new LogicalConcept(this._servletRequest.isRequestedSessionIdFromURL());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept isRequestedSessionIdValid() {
        if (this._servletRequest != null) {
            return new LogicalConcept(this._servletRequest.isRequestedSessionIdValid());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept isUserInRole(StringConcept roleName) {
        if (this._servletRequest != null) {
            return new LogicalConcept(this._servletRequest.isUserInRole(roleName.toString()));
        }
        return new LogicalConcept(false);
    }

    public ConceptDefinition getConceptDefinition() {
        return ServletRequestDefinition.getReference();
    }

    public void setRequest(HttpServletRequest request) {
        this._servletRequest = request;
    }

    public HttpServletRequest getReuqest() {
        return this._servletRequest;
    }

    public Object clone() {
        return this;
    }

    public ServletRequestConcept() {
    }

    public ServletRequestConcept(HttpServletRequest request, ServletContext context) {
        this._servletRequest = request;
        this._servletContext = context;
    }
}

