/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.CookieConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.servlet.ServletResponseDefinition;

public class ServletResponseConcept
extends JavaConcept {
    private HttpServletResponse _response = null;

    public Concept create() {
        return this;
    }

    public void setContentType(StringConcept contentType) {
        if (this._response != null) {
            this._response.setContentType(contentType.toString());
        }
    }

    public void addCookie(CookieConcept cookie) {
        if (this._response != null) {
            this._response.addCookie(cookie.getCookie().getJavaCookie());
        }
    }

    public StringConcept encodeURL(StringConcept url) {
        if (this._response != null) {
            return new StringConcept(this._response.encodeURL(url.toString()));
        }
        return new StringConcept();
    }

    public StringConcept encodeRedirectURL(StringConcept url) {
        if (this._response != null) {
            return new StringConcept(this._response.encodeRedirectURL(url.toString()));
        }
        return new StringConcept();
    }

    public void setContentLength(IntegerConcept length) {
        if (this._response != null) {
            this._response.setContentLength(length.getInt());
        }
    }

    public void setBufferSize(IntegerConcept size) {
        if (this._response != null) {
            this._response.setBufferSize(size.getInt());
        }
    }

    public void setStatus(IntegerConcept statusCode) {
        if (this._response != null) {
            this._response.setStatus(statusCode.getInt());
        }
    }

    public void sendError(IntegerConcept statusCode, StringConcept message) {
        if (this._response != null) {
            this._response.setStatus(statusCode.getInt(), message.toString());
        }
    }

    public void sendError(IntegerConcept statusCode) {
        if (this._response != null) {
            this._response.setStatus(statusCode.getInt());
        }
    }

    public void setHeader(StringConcept name, StringConcept value) {
        if (this._response != null) {
            this._response.setHeader(name.toString(), value.toString());
        }
    }

    public void addHeader(StringConcept name, StringConcept value) {
        if (this._response != null) {
            this._response.addHeader(name.toString(), value.toString());
        }
    }

    public void sendRedirect(StringConcept location) {
        block3: {
            if (this._response != null) {
                try {
                    this._response.sendRedirect(location.toString());
                }
                catch (IOException ex) {
                    if (!mn8RuntimeFlags.isDebug() && !mn8RuntimeFlags.isVerbose()) break block3;
                    System.err.println("ServletResponse:sendRedirect: " + ex.getMessage());
                }
            }
        }
    }

    public IntegerConcept getBufferSize() {
        if (this._response != null) {
            return new IntegerConcept(this._response.getBufferSize());
        }
        return new IntegerConcept(-1L);
    }

    public StringConcept getCharacterEncoding() {
        if (this._response != null) {
            return new StringConcept(this._response.getCharacterEncoding());
        }
        return new StringConcept();
    }

    public void flushBuffer() {
        block3: {
            if (this._response != null) {
                try {
                    this._response.flushBuffer();
                }
                catch (IOException ex) {
                    if (!mn8RuntimeFlags.isDebug() && !mn8RuntimeFlags.isVerbose()) break block3;
                    System.err.println("ServletResponse:flushBuffer: " + ex.getMessage());
                }
            }
        }
    }

    public void reset() {
        if (this._response != null) {
            this._response.reset();
        }
    }

    public LogicalConcept isCommitted() {
        if (this._response != null) {
            return new LogicalConcept(this._response.isCommitted());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept containsHeader(StringConcept name) {
        if (this._response != null) {
            return new LogicalConcept(this._response.containsHeader(name.toString()));
        }
        return new LogicalConcept(false);
    }

    public ConceptDefinition getConceptDefinition() {
        return ServletResponseDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    public ServletResponseConcept() {
    }

    public ServletResponseConcept(HttpServletResponse response) {
        this._response = response;
    }
}

