/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.media.mn8.Helper;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.servlet.MapInfoResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class mn8RequestMapper {
    protected Pattern[] _pathExpressions = null;
    protected String[] _conceptNames = null;
    protected SeriesConcept[] _conceptParams = null;
    protected Perl5Matcher _matcher = new Perl5Matcher();

    public void parseMapInfo(File mapInfo) {
        MapInfoParser mapParser = new MapInfoParser(mapInfo);
        if (mapParser.conceptName != null && mapParser.conceptParams != null && mapParser.pathInfo != null && mapParser.conceptParams.size() == mapParser.conceptName.size() && mapParser.conceptName.size() == mapParser.pathInfo.size()) {
            this._pathExpressions = new Pattern[mapParser.pathInfo.size()];
            this._conceptNames = new String[mapParser.pathInfo.size()];
            this._conceptParams = new SeriesConcept[mapParser.pathInfo.size()];
            Perl5Compiler compiler = new Perl5Compiler();
            int i = 0;
            while (i < mapParser.pathInfo.size()) {
                try {
                    this._pathExpressions[i] = compiler.compile((String)mapParser.pathInfo.elementAt(i));
                    this._conceptNames[i] = (String)mapParser.conceptName.elementAt(i);
                    this._conceptParams[i] = (SeriesConcept)mapParser.conceptParams.elementAt(i);
                }
                catch (MalformedPatternException mex) {
                    mex.printStackTrace();
                }
                ++i;
            }
        }
    }

    public MapInfoResult getMatch(String uri) {
        int i = 0;
        while (i < this._pathExpressions.length) {
            if (this._matcher.matches(uri.trim(), this._pathExpressions[i])) {
                MapInfoResult result = new MapInfoResult();
                result.mappedPath = this._pathExpressions[i].getPattern();
                result.conceptName = this._conceptNames[i];
                result.conceptParams = this._conceptParams[i];
                return result;
            }
            ++i;
        }
        return null;
    }

    public void printDebugInfo() {
        System.err.println("MN8 Servlet : Map Info ");
        if (this._pathExpressions != null && this._conceptNames != null && this._conceptParams != null) {
            int i = 0;
            while (i < this._pathExpressions.length) {
                System.err.println("\t" + i + ".) " + this._pathExpressions[i].getPattern() + " -> " + this._conceptNames[i]);
                Vector params = this._conceptParams[i].getVector();
                System.err.println("\t\t With the parameters:");
                int j = 0;
                while (j < params.size()) {
                    System.err.println("\t\t" + ((StringConcept)params.elementAt(j)).toString());
                    ++j;
                }
                ++i;
            }
        }
    }

    class MapInfoParser
    extends DefaultHandler {
        public Vector pathInfo = new Vector();
        public Vector conceptName = new Vector();
        public Vector conceptParams = new Vector();
        private String _conceptName;
        private SeriesConcept _conceptParams;
        private boolean _isPath = false;
        private boolean _isParam = false;
        private StringBuffer _value = null;

        public void startElement(String uri, String qname, String name, Attributes attr) throws SAXException {
            if (name.equalsIgnoreCase("path")) {
                this._isPath = true;
            }
            if (name.equalsIgnoreCase("parameters")) {
                this._conceptParams = new SeriesConcept();
            }
            if (name.equalsIgnoreCase("concept")) {
                if (attr.getLength() >= 1 && attr.getQName(0).toLowerCase().equals("name") && (attr.getValue(0) != null || !attr.getValue(0).equals(""))) {
                    this._conceptName = attr.getValue(0);
                } else if (attr.getLength() >= 1 && attr.getQName(0).toLowerCase().equals("path") && (attr.getValue(0) != null || !attr.getValue(0).equals(""))) {
                    this._conceptName = attr.getValue(0);
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String str;
            if (this._value == null) {
                this._value = new StringBuffer();
            }
            if ((str = new String(ch, start, length)).trim().length() > 0) {
                this._value.append(str);
            }
        }

        public void endElement(String uri, String name, String qname) throws SAXException {
            if ((name.equalsIgnoreCase("path") || qname.equalsIgnoreCase("path")) && this._value.toString() != null) {
                this.pathInfo.add(this._value.toString().trim());
                this._value = null;
            }
            if ((name.equalsIgnoreCase("param") || qname.equalsIgnoreCase("param")) && this._value.toString() != null) {
                this._conceptParams.add(new StringConcept(Helper.fillWithValues(this._value.toString())));
                this._value = null;
            }
            if ((name.equalsIgnoreCase("concept") || qname.equalsIgnoreCase("concept")) && this._conceptName != null) {
                if (this._conceptParams == null) {
                    this._conceptParams = new SeriesConcept();
                }
                this.conceptName.add(this._conceptName);
                this.conceptParams.add(this._conceptParams);
                this._conceptParams = null;
                this._conceptName = null;
            }
        }

        public void error(SAXParseException spe) throws SAXParseException {
            throw spe;
        }

        public MapInfoParser(File mapInfoFile) {
            try {
                SAXParserFactory sxParserFactory = SAXParserFactory.newInstance();
                SAXParser sxParser = sxParserFactory.newSAXParser();
                XMLReader sxReader = sxParser.getXMLReader();
                sxReader.setContentHandler(this);
                sxReader.parse(new InputSource(new FileReader(mapInfoFile)));
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }
}

