/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.media.mn8.Helper;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.event.ConceptNotFoundException;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.servlet.MapInfoResult;
import org.media.mn8.servlet.ServletRequestConcept;
import org.media.mn8.servlet.ServletResponseConcept;
import org.media.mn8.servlet.mn8RequestMapper;
import org.media.mn8.servlet.mn8SystemServlet;

public class mn8Runner
extends HttpServlet {
    static final String ENV_PATH = "env:/servlet/";
    private ServletContext _servletContext = null;
    private ServletConfig _servletConfig = null;
    private mn8RequestMapper _requestMapper = new mn8RequestMapper();
    private boolean _enableConceptLookup = false;
    private boolean _enableMapInfo = false;

    public void init(ServletConfig config) throws ServletException {
        block13: {
            System.setProperty("java.protocol.handler.pkgs", "org.media.mn8.protocol");
            this._servletConfig = config;
            mn8Interpreter.initialize();
            try {
                this._servletContext = config.getServletContext();
                NamingManager.envBind("env:/servlet/server.info", new StringConcept(this._servletContext.getServerInfo()));
                NamingManager.envBind("env:/servlet/servlet.name", new StringConcept(config.getServletName()));
                NamingManager.envBind("env:/servlet/servlet.api.version", new StringConcept("" + this._servletContext.getMajorVersion() + "." + this._servletContext.getMinorVersion()));
                Enumeration paramNames = config.getInitParameterNames();
                while (paramNames.hasMoreElements()) {
                    String name = (String)paramNames.nextElement();
                    NamingManager.envBind("env:/servlet//parameters/" + name, new StringConcept(Helper.fillWithValues(config.getInitParameter(name))));
                }
                if (config.getInitParameter("debug") != null && config.getInitParameter("debug").equalsIgnoreCase("true")) {
                    mn8RuntimeFlags.setDebug(true);
                }
                if (config.getInitParameter("verbose") != null && config.getInitParameter("verbose").equalsIgnoreCase("true")) {
                    mn8RuntimeFlags.setVerbose(true);
                }
                if (config.getInitParameter("EnableConceptLookup") != null && config.getInitParameter("EnableConceptLookup").equalsIgnoreCase("true")) {
                    this._enableConceptLookup = true;
                }
                if (config.getInitParameter("MapInfo") == null) break block13;
                String path = config.getInitParameter("MapInfo");
                if ((path = Helper.fillWithValues(path)).trim().equals("")) {
                    try {
                        if (this._servletContext.getResource("/mn8MapInfo.xml") != null) {
                            path = this._servletContext.getResource("/mn8MapInfo.xml").toString();
                        }
                    }
                    catch (MalformedURLException mex) {
                        System.err.println(mex.getMessage());
                    }
                }
                if (path == null || path.trim().equals("")) break block13;
                File fpath = new File(path);
                try {
                    System.err.println("Loading MN8 Mapping Info from: " + fpath.toURL().toString());
                }
                catch (MalformedURLException mex) {
                    System.err.println(mex.getMessage());
                }
                this._enableMapInfo = true;
                this._requestMapper.parseMapInfo(fpath);
                if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                    this._requestMapper.printDebugInfo();
                }
            }
            catch (NamingException nex) {
                throw new ServletException(nex.getMessage());
            }
        }
    }

    public String getServletInfo() {
        return "mn8Runner is a Java servlet which allows MN8 based scripts or concepts to be run server side, for more information on MN8 please visit: http://mappa.mundi.net/spacemapper";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletRequestConcept requestConc = new ServletRequestConcept(request, this._servletContext);
        ServletResponseConcept responseConc = new ServletResponseConcept(response);
        mn8Interpreter.setOut(new PrintStream((OutputStream)response.getOutputStream()), Thread.currentThread());
        mn8Interpreter.setErr(System.err, Thread.currentThread());
        try {
            block24: {
                try {
                    if (request.getPathTranslated() == null) break block24;
                    File path = new File(request.getPathTranslated());
                    SeriesConcept paramVal = new SeriesConcept();
                    paramVal.add(requestConc);
                    paramVal.add(responseConc);
                    if (path.exists() && path.isFile() && path.getName().toLowerCase().endsWith(".mn8")) {
                        SeriesConcept param = new SeriesConcept();
                        param.add(paramVal);
                        mn8Interpreter.threadExecuteURLRun(path.toURL().toString(), null, param);
                        break block24;
                    }
                    if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                        System.err.println("MN8 Servlet: not direct call");
                    }
                    MapInfoResult result = this._requestMapper.getMatch(request.getPathInfo());
                    if (this._enableMapInfo && result != null) {
                        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                            System.err.println("MN8 Servlet: map enabled");
                        }
                        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                            System.err.println("MN8 Servlet: mapped to : " + result.conceptName);
                        }
                        if (!result.conceptName.equalsIgnoreCase("_SYSTEM_")) {
                            paramVal.addSeries(result.conceptParams);
                            SeriesConcept param = new SeriesConcept();
                            param.add(paramVal);
                            mn8Interpreter.threadExecuteURLRun(result.conceptName, null, param);
                            break block24;
                        } else {
                            new mn8SystemServlet(this._servletConfig, request, response).serve();
                        }
                        break block24;
                    }
                    if (this._enableConceptLookup) {
                        String conceptName = request.getPathInfo();
                        if (conceptName.startsWith("/")) {
                            conceptName = conceptName.substring(1);
                        }
                        if (conceptName.indexOf("/") != -1) {
                            conceptName = conceptName.substring(0, conceptName.indexOf("/"));
                        }
                        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                            System.err.println("MN8 Servlet: Concept Lookup : " + conceptName);
                        }
                        try {
                            String fileName = new mn8Loader().findConcept(conceptName);
                            if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                                System.err.println("MN8 Servlet: Concept Lookup found: " + fileName);
                            }
                            SeriesConcept param = new SeriesConcept();
                            param.add(paramVal);
                            mn8Interpreter.threadExecuteURLRun(fileName, null, param);
                        }
                        catch (ConceptNotFoundException cex) {
                            response.sendError(404, cex.getMessage());
                            cex.printStackTrace();
                        }
                        break block24;
                    }
                    if (path.exists() && path.isFile()) {
                        response.sendError(501);
                        break block24;
                    }
                    if (path.exists() && path.isDirectory()) {
                        response.sendError(403, "Directory listing forbidden on this server.");
                        break block24;
                    }
                    response.sendError(404, "The requested URL was not found on this server.");
                }
                catch (RuntimeException rex) {
                    response.sendError(500, rex.getMessage());
                    throw rex;
                }
            }
            Object var6_15 = null;
            PrintStream out = mn8Interpreter.getOut(Thread.currentThread());
            PrintStream err = mn8Interpreter.getErr(Thread.currentThread());
            if (out != System.out) {
                out.flush();
                out.close();
            }
            if (err != System.err) {
                err.flush();
                err.close();
            }
            mn8Interpreter.cleanStreams(Thread.currentThread());
            return;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            PrintStream out = mn8Interpreter.getOut(Thread.currentThread());
            PrintStream err = mn8Interpreter.getErr(Thread.currentThread());
            if (out != System.out) {
                out.flush();
                out.close();
            }
            if (err != System.err) {
                err.flush();
                err.close();
            }
            mn8Interpreter.cleanStreams(Thread.currentThread());
            throw throwable;
        }
    }
}

