/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ArgParser {
    private static Properties prop = new Properties();
    private static Vector unparsed = new Vector();

    public boolean parse(String[] argv) {
        if (!this.isValid(argv)) {
            return false;
        }
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            prop.setProperty(key, this.getArgs(argv, key));
        }
        return true;
    }

    public String getValue(String key) {
        String value = prop.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value.trim().length() < 1) {
            return null;
        }
        if (value.equals(" - ")) {
            return "";
        }
        return value;
    }

    public Vector getUnparsedArg() {
        return unparsed;
    }

    private final boolean isValid(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (prop.getProperty(arg) == null) {
                if (prop.getProperty(arg + ":") != null) {
                    ++i;
                } else {
                    unparsed.addElement(arg);
                }
            }
            ++i;
        }
        return true;
    }

    private final String getArgs(String[] argx, String key) {
        int i = 0;
        while (i < argx.length) {
            String arg = argx[i];
            if (key.equals(arg)) {
                return " - ";
            }
            if (key.equals(arg + ":")) {
                if (i + 1 < argx.length && prop.getProperty(argx[i + 1]) == null && prop.getProperty(argx[i + 1] + ":") == null) {
                    return argx[i + 1];
                }
                return " - ";
            }
            ++i;
        }
        return "";
    }

    public ArgParser(String keys, String delim) {
        StringTokenizer st = new StringTokenizer(keys, delim);
        while (st.hasMoreTokens()) {
            prop.setProperty(st.nextToken(), "");
        }
    }

    public ArgParser(String keys) {
        StringTokenizer st = new StringTokenizer(keys);
        while (st.hasMoreTokens()) {
            prop.setProperty(st.nextToken(), "");
        }
    }
}

