/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

import java.util.Comparator;
import java.util.NoSuchElementException;

public final class BinaryHeap {
    public static final Comparator MIN_COMPARATOR = new MinComparator();
    public static final Comparator MAX_COMPARATOR = new MaxComparator();
    private static final int DEFAULT_CAPACITY = 13;
    private static final Comparator DEFAULT_COMPARATOR = MIN_COMPARATOR;
    private int m_size;
    private Object[] m_elements;
    private Comparator m_comparator;

    public final void clear() {
        this.m_size = 0;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public final boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public final int size() {
        return this.m_size;
    }

    public final void insert(Object element) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpHeap(element);
    }

    public final Object peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public final Object pop() throws NoSuchElementException {
        Object result = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            this.percolateDownHeap(1);
        }
        return result;
    }

    private final void percolateDownHeap(int index) {
        Object element = this.m_elements[index];
        int hole = index;
        int child = hole << 1;
        while (child <= this.m_size) {
            if (child != this.m_size && this.m_comparator.compare(this.m_elements[child + 1], this.m_elements[child]) < 0) {
                ++child;
            }
            if (this.m_comparator.compare(this.m_elements[child], element) >= 0) break;
            this.m_elements[hole] = this.m_elements[child];
            hole = child;
            child = hole << 1;
        }
        this.m_elements[hole] = element;
    }

    private final void percolateUpHeap(Object element) {
        int hole = ++this.m_size;
        int next = hole >> 1;
        this.m_elements[hole] = element;
        while (hole > 1 && this.m_comparator.compare(element, this.m_elements[next]) < 0) {
            this.m_elements[hole] = this.m_elements[next];
            hole = next;
            next = hole >> 1;
        }
        this.m_elements[hole] = element;
    }

    private final void grow() {
        Object[] elements = new Object[this.m_elements.length * 2];
        System.arraycopy(this.m_elements, 0, elements, 0, this.m_elements.length);
        this.m_elements = elements;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        int i = 1;
        while (i < this.m_size + 1) {
            if (i != 1) {
                sb.append(", ");
            }
            sb.append(this.m_elements[i]);
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }

    public BinaryHeap() {
        this(13, DEFAULT_COMPARATOR);
    }

    public BinaryHeap(int capacity, Comparator comparator) {
        this.m_elements = new Object[capacity + 1];
        this.m_comparator = comparator;
    }

    private static final class MinComparator
    implements Comparator {
        public final int compare(Object lhs, Object rhs) {
            return ((Comparable)lhs).compareTo(rhs);
        }

        MinComparator() {
        }
    }

    private static final class MaxComparator
    implements Comparator {
        public final int compare(Object lhs, Object rhs) {
            return ((Comparable)rhs).compareTo(lhs);
        }

        MaxComparator() {
        }
    }
}

