/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

public class ConceptNavPatterns {
    public static boolean isAbsolutePath(String path) {
        return path != null && path.indexOf("/") == 0;
    }

    public static boolean isRelativePath(String path) {
        return !ConceptNavPatterns.isAbsolutePath(path);
    }

    public static boolean isAttribute(String pathItem) {
        return pathItem.indexOf("@") == 0 || pathItem.indexOf("/@") == 0;
    }

    public static String getAttributeName(String pathItem) {
        if (pathItem.startsWith("/@")) {
            return pathItem.substring(2);
        }
        if (pathItem.startsWith("@")) {
            return pathItem.substring(1);
        }
        return null;
    }

    public static String getElementName(String pathItem) {
        if (pathItem.startsWith("/")) {
            return pathItem.substring(1);
        }
        return pathItem;
    }

    public static String getFirstItem(String path) {
        Object firstItem = null;
        Object remainingItems = null;
        int startIdx = 1;
        if (path.startsWith("/@")) {
            startIdx = 2;
        }
        if (path.indexOf("/", startIdx) < path.indexOf("@", startIdx) && path.indexOf("/", startIdx) != -1) {
            return path.substring(0, path.indexOf("/", startIdx));
        }
        if (path.indexOf("@", startIdx) != -1) {
            return path.substring(0, path.indexOf("@", startIdx));
        }
        if (path.indexOf("/", startIdx) != -1) {
            return path.substring(0, path.indexOf("/", startIdx));
        }
        return path;
    }

    public static String getRemainingItems(String path) {
        String first = ConceptNavPatterns.getFirstItem(path);
        if (first.length() == path.length()) {
            return null;
        }
        return path.substring(first.length());
    }
}

