/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8ScriptMethod;
import org.media.mn8.util.BinaryHeap;
import org.media.mn8.util.Cron;
import org.media.mn8.util.CronScheduledEntry;
import org.media.mn8.util.SynchronizedHeap;

public class CronTimeScheduler
implements Runnable {
    private boolean m_running;
    private Hashtable m_entries = new Hashtable();
    private SynchronizedHeap m_priorityQueue = new SynchronizedHeap(new BinaryHeap());

    public synchronized void addTrigger(String name, Cron trigger, String target) throws Exception {
        try {
            this.removeTrigger(name);
        }
        catch (NoSuchElementException nse) {
            // empty catch block
        }
        CronScheduledEntry entry = new CronScheduledEntry(name, trigger, target);
        this.m_entries.put(name, entry);
        boolean added = this.rescheduleEntry(entry, false);
        if (!added) {
            return;
        }
        try {
            if (entry == this.m_priorityQueue.peek()) {
                this.notifyAll();
            }
        }
        catch (NoSuchElementException nse) {
            throw new Exception("Unexpected exception: " + nse.getMessage());
        }
    }

    public synchronized void removeTrigger(String name) throws NoSuchElementException {
        CronScheduledEntry entry = this.getEntry(name);
        entry.invalidate();
        this.m_entries.remove(name);
    }

    public synchronized void resetTrigger(String name) throws NoSuchElementException {
        CronScheduledEntry entry = this.getEntry(name);
        this.rescheduleEntry(entry, true);
    }

    private final synchronized boolean rescheduleEntry(CronScheduledEntry timeEntry, boolean clone) {
        long next;
        CronScheduledEntry entry = timeEntry;
        if (clone) {
            entry = new CronScheduledEntry(timeEntry.getName(), timeEntry.getTimeTrigger(), timeEntry.getTarget());
            timeEntry.invalidate();
            this.m_entries.remove(timeEntry.getName());
            this.m_entries.put(timeEntry.getName(), entry);
        }
        if (0L < (next = entry.getTimeTrigger().getTimeAfter(System.currentTimeMillis()))) {
            entry.setNextTime(next);
            this.m_priorityQueue.insert(entry);
            if (entry == this.m_priorityQueue.peek()) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    public CronScheduledEntry getEntry(String name) throws NoSuchElementException {
        CronScheduledEntry entry = (CronScheduledEntry)this.m_entries.get(name);
        if (entry != null) {
            return entry;
        }
        throw new NoSuchElementException();
    }

    private final void runEntry(CronScheduledEntry entry) {
        Runnable runnable = new Runnable(this, entry){
            private final /* synthetic */ CronTimeScheduler this$0;
            private final /* synthetic */ CronScheduledEntry val$entry;

            public final void run() {
                String target = this.val$entry.getTarget();
                System.out.println("STARTING CRON: " + target);
                StringConcept cname = new StringConcept();
                SeriesConcept param = new SeriesConcept();
                SeriesConcept iparam = new SeriesConcept();
                StringTokenizer st = new StringTokenizer(target);
                int idx = 0;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (idx == 0) {
                        cname = new StringConcept(token);
                    } else {
                        param.add(new StringConcept(token));
                    }
                    ++idx;
                }
                JavaConcept con = mn8Loader.instantiateConcept(cname.getValue());
                mn8ScriptMethod method = (mn8ScriptMethod)con.getConceptMethod(new StringConcept("main:Series"));
                iparam.add(param);
                method.invoke(cname.getValue(), iparam);
            }
            {
                this.val$entry = val$entry;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(CronTimeScheduler cronTimeScheduler) {
            }
        };
        try {
            new Thread(runnable).start();
        }
        catch (Exception e) {
            new ErrorConcept("warning", "errExecTrigger", "Error executing trigger " + entry.getName());
        }
    }

    public void start() throws Exception {
        new Thread(this).start();
    }

    public void stop() {
        this.m_running = false;
        CronTimeScheduler cronTimeScheduler = this;
        synchronized (cronTimeScheduler) {
            this.notifyAll();
        }
    }

    public void run() {
        this.m_running = true;
        while (this.m_running) {
            Object entry;
            long duration = 0L;
            if (!this.m_priorityQueue.isEmpty()) {
                entry = null;
                CronTimeScheduler cronTimeScheduler = this;
                synchronized (cronTimeScheduler) {
                    entry = this.getNextEntry();
                    if (entry == null) {
                        continue;
                    }
                    duration = ((CronScheduledEntry)entry).getNextTime() - System.currentTimeMillis();
                    if (duration < 0L) {
                        this.m_priorityQueue.pop();
                    }
                }
                if (duration < 0L) {
                    this.runEntry((CronScheduledEntry)entry);
                    this.rescheduleEntry((CronScheduledEntry)entry, false);
                    continue;
                }
                if (0L == duration) {
                    duration = 1L;
                }
            }
            try {
                entry = this;
                synchronized (entry) {
                    Thread.sleep(duration);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final synchronized CronScheduledEntry getNextEntry() {
        CronScheduledEntry entry = (CronScheduledEntry)this.m_priorityQueue.peek();
        while (!entry.isValid()) {
            this.m_priorityQueue.pop();
            if (this.m_priorityQueue.isEmpty()) {
                return null;
            }
            entry = (CronScheduledEntry)this.m_priorityQueue.peek();
        }
        return entry;
    }
}

