/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.media.mn8.mn8Interpreter;

public class LineWrapper {
    private static final int BLOCK_SIZE = 8096;
    private static final int TAB_SIZE = 8;
    private static int MAX_COLUMN = 72;
    private static String ALIGN = "LEFT";
    private static String TEXT = "";

    public static void main(String[] args) {
        File f;
        if (args.length < 1) {
            System.out.println("Usage : java LineWrapper filename [ column [ justify ] ]");
            System.out.println("   - filename, filename for normalizing");
            System.out.println("   - column, number of columns for result string ( default 80 )");
            System.out.println("   - justify, is text alignment : left(default), center, right, justified \n");
            System.exit(1);
        }
        if (!(f = new File(args[0])).exists() || !f.canRead()) {
            System.out.println("File: " + args[0] + " doesn't exists or haven't read permissions.");
            System.exit(1);
        }
        if ((TEXT = LineWrapper.readFile(f)) == null) {
            System.out.println("I/O error: " + args[0] + " can't be readed.");
            System.exit(1);
        }
        if (args.length > 1) {
            try {
                MAX_COLUMN = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Column argument: '" + args[1] + "' isn't a number.");
                System.exit(1);
            }
            if (args.length > 2) {
                String align = args[2].toUpperCase().trim();
                if (!(align.equals("LEFT") || align.equals("CENTER") || align.equals("RIGHT") || align.equals("JUSTIFIED"))) {
                    System.out.println("Justify argument can be : left, center, right or justified.");
                    System.exit(1);
                }
                ALIGN = align;
            }
        }
        System.out.println(LineWrapper.alignText(TEXT, MAX_COLUMN, ALIGN));
    }

    private static final String readFile(File f) {
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[8096];
        int size = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while ((size = reader.read(buffer, 0, 8096)) != -1) {
                sb.append(new String(buffer, 0, size));
            }
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    private static final String removeLF(String str) {
        StringBuffer sb = new StringBuffer();
        int LFNr = 0;
        int spaceNr = 0;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '\t') {
                spaceNr += 8;
            } else if (ch == '\n') {
                spaceNr = i + 1 < str.length() && ++LFNr < 2 && !Character.isWhitespace(str.charAt(i + 1)) ? 1 : 0;
            } else if (!Character.isWhitespace(ch)) {
                if (LFNr > 1) {
                    int j = 0;
                    while (j < LFNr) {
                        sb.append(mn8Interpreter.EOL);
                        ++j;
                    }
                }
                sb.append(LineWrapper.space(spaceNr) + ch);
                LFNr = 0;
                spaceNr = 0;
            } else if (ch == ' ') {
                ++spaceNr;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String alignText(String str, int column, String align) {
        String _str = LineWrapper.removeLF(str);
        StringBuffer sb = new StringBuffer(!_str.endsWith("\n") && !_str.endsWith("\r\n") && !_str.endsWith("\r") ? _str + mn8Interpreter.EOL : _str);
        int wordNr = 0;
        int curPoz = 0;
        int prevPoz = 0;
        int start = 0;
        while (curPoz < sb.length()) {
            char ch = sb.charAt(curPoz);
            if (Character.isWhitespace(ch) && ch != '\n' && ch != '\r') {
                if (curPoz - start > column) {
                    if (wordNr == 0) {
                        sb.insert(curPoz, mn8Interpreter.EOL);
                        prevPoz = curPoz += 1 + mn8Interpreter.EOL.length();
                        start = curPoz;
                        continue;
                    }
                    sb.insert(prevPoz, mn8Interpreter.EOL);
                    start = curPoz = prevPoz;
                    wordNr = 0;
                    continue;
                }
                ++wordNr;
                prevPoz = ++curPoz;
                continue;
            }
            if (ch == '\n') {
                if (curPoz - start > column) {
                    sb.insert(prevPoz, mn8Interpreter.EOL);
                }
                prevPoz = start = (curPoz += 2);
                wordNr = 0;
                continue;
            }
            ++curPoz;
        }
        String result = sb.toString();
        if (align.trim().equalsIgnoreCase("left")) {
            result = LineWrapper.alignLeft(sb.toString(), column);
        }
        if (align.trim().equalsIgnoreCase("right")) {
            result = LineWrapper.alignRight(sb.toString(), column);
        }
        if (align.trim().equalsIgnoreCase("center")) {
            result = LineWrapper.alignCenter(sb.toString(), column);
        }
        if (align.trim().equalsIgnoreCase("justified")) {
            result = LineWrapper.justified(sb.toString(), column);
        }
        if (!str.endsWith("\r\n") && !str.endsWith("\n") && !str.endsWith("\r") && result.endsWith(mn8Interpreter.EOL)) {
            result = ("x" + result).trim().substring(1);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String alignLeft(String str, int column) {
        int poz;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((poz = str.indexOf(10, start)) != -1) {
            void var4_4;
            sb.append(str.substring(start, (int)var4_4).trim() + mn8Interpreter.EOL);
            start = var4_4 + true;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String alignRight(String str, int column) {
        int poz;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((poz = str.indexOf(10, start)) != -1) {
            void var4_4;
            String _str = str.substring(start, (int)var4_4).trim();
            int nrSpace = column - _str.length();
            sb.append(LineWrapper.space(nrSpace) + _str + mn8Interpreter.EOL);
            start = var4_4 + true;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String alignCenter(String str, int column) {
        int poz;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((poz = str.indexOf(10, start)) != -1) {
            void var4_4;
            String _str = str.substring(start, (int)var4_4).trim();
            int nrSpace = column - _str.length();
            sb.append(LineWrapper.space(nrSpace / 2) + _str + mn8Interpreter.EOL);
            start = var4_4 + true;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String justified(String str, int column) {
        int poz;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((poz = str.indexOf(10, start)) != -1) {
            void var4_4;
            String _str = ("_" + str.substring(start, (int)var4_4)).trim();
            _str = _str.substring(1);
            int nrSpace = column - _str.length();
            int nrWord = LineWrapper.getWordNr(_str);
            if (nrWord > 1 && var4_4 + true < str.length() && str.charAt((int)(var4_4 + true)) != '\n') {
                _str = LineWrapper.justifyLine(_str, nrWord, nrSpace);
            }
            sb.append(_str + mn8Interpreter.EOL);
            start = var4_4 + true;
        }
        return sb.toString();
    }

    private static final String justifyLine(String line, int wordNr, int spaceNr) {
        StringBuffer sb = new StringBuffer();
        boolean isSpace = false;
        boolean firstWord = false;
        int plusSpace = spaceNr % (wordNr - 1);
        int nrSpace = spaceNr / (wordNr - 1);
        int i = 0;
        while (i < line.length()) {
            if (Character.isWhitespace(line.charAt(i)) && !isSpace && firstWord) {
                isSpace = true;
            } else if (!Character.isWhitespace(line.charAt(i))) {
                firstWord = true;
                if (isSpace) {
                    isSpace = false;
                    sb.append(LineWrapper.space(nrSpace));
                    if (plusSpace-- > 0) {
                        sb.append(' ');
                    }
                }
            }
            sb.append(line.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static final String space(int nrSpace) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nrSpace) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private static final int getWordNr(String str) {
        boolean isSpace = false;
        int wNr = 1;
        int i = 0;
        while (i < str.length()) {
            if (Character.isWhitespace(str.charAt(i)) && !isSpace) {
                isSpace = true;
            } else if (!Character.isWhitespace(str.charAt(i)) && isSpace) {
                isSpace = false;
                ++wNr;
            }
            ++i;
        }
        return wNr;
    }
}

