/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class SystemEnvReader {
    private static final SystemEnvReader _envReader = new SystemEnvReader();

    public static Properties getSystemEnvironment() throws IOException {
        return _envReader.parseResult(_envReader.executeEnvCommand("env"));
    }

    public static Properties getSystemEnvironment(String command) throws IOException {
        return _envReader.parseResult(_envReader.executeEnvCommand(command));
    }

    public static void main(String[] args) {
        try {
            Properties map;
            if (args.length > 0) {
                Properties properties = SystemEnvReader.getSystemEnvironment(args[0]);
            } else {
                map = SystemEnvReader.getSystemEnvironment("env");
            }
            if (((Hashtable)map).isEmpty()) {
                System.out.println("Usage: org.media.mn8.util.SystemEnvReader cmd \n     where cmd is the env command on your op sys");
            }
            Iterator iterator = ((Hashtable)map).keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                System.out.println(key + "=" + ((Hashtable)map).get(key));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final Properties parseResult(InputStream is) throws IOException {
        Properties result = new Properties();
        LineNumberReader lnreader = new LineNumberReader(new InputStreamReader(is));
        String line = "";
        while ((line = lnreader.readLine()) != null) {
            if (line == null || line.indexOf("=") < 0) continue;
            ((Hashtable)result).put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
        }
        return result;
    }

    private final InputStream executeEnvCommand(String command) throws IOException {
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(command);
        return p.getInputStream();
    }
}

