/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarBuffer {
    public static final int DEFAULT_RCDSIZE = 512;
    public static final int DEFAULT_BLKSIZE = 10240;
    private InputStream is;
    private OutputStream os;
    private byte[] blkBuffer;
    private int currBlkIdx;
    private int currRecIdx;
    private int blkSize;
    private int recSize;
    private int recperblk;

    public int getRecordSize() {
        return this.recSize;
    }

    public int getBlockSize() {
        return this.blkSize;
    }

    public boolean isEOFRecord(byte[] rec) {
        int i = 0;
        int s = this.getRecordSize();
        while (i < s) {
            if (rec[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] readRecord() throws IOException {
        if (this.is == null) {
            throw new IOException("InputStream is null");
        }
        if (this.currRecIdx >= this.recperblk && !this.readBlock()) {
            return null;
        }
        byte[] result = new byte[this.recSize];
        System.arraycopy(this.blkBuffer, this.currRecIdx * this.recSize, result, 0, this.recSize);
        ++this.currRecIdx;
        return result;
    }

    public void writeRecord(byte[] buffer) throws IOException {
        if (this.os == null) {
            throw new IOException("OutputStream is null");
        }
        if (buffer.length != this.recSize) {
            throw new IOException("Buffer length must be: " + this.recSize);
        }
        if (this.currRecIdx >= this.recperblk) {
            this.writeBlock();
        }
        System.arraycopy(buffer, 0, this.blkBuffer, this.currRecIdx * this.recSize, this.recSize);
        ++this.currRecIdx;
    }

    public void writeRecord(byte[] buf, int offset) throws IOException {
        if (this.os == null) {
            throw new IOException("OutputStream is null");
        }
        if (offset + this.recSize > buf.length) {
            throw new IOException("Buffer length must be: " + this.recSize);
        }
        if (this.currRecIdx >= this.recperblk) {
            this.writeBlock();
        }
        System.arraycopy(buf, offset, this.blkBuffer, this.currRecIdx * this.recSize, this.recSize);
        ++this.currRecIdx;
    }

    public void close() throws IOException {
        if (this.os != null) {
            if (this.currRecIdx > 0) {
                this.writeBlock();
            }
            this.os.close();
            this.os = null;
        }
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }

    private final boolean readBlock() throws IOException {
        if (this.is == null) {
            throw new IOException("InputStream is null");
        }
        this.currRecIdx = 0;
        int offset = 0;
        int bn = this.blkSize;
        while (bn > 0) {
            long nb = this.is.read(this.blkBuffer, offset, bn);
            if (nb == -1L) break;
            offset = (int)((long)offset + nb);
            bn = (int)((long)bn - nb);
        }
        int i = bn;
        while (i > 0) {
            this.blkBuffer[this.blkSize - i] = 0;
            --i;
        }
        ++this.currBlkIdx;
        return true;
    }

    private final void writeBlock() throws IOException {
        if (this.os == null) {
            throw new IOException("OutputStream is null");
        }
        this.os.write(this.blkBuffer, 0, this.blkSize);
        this.os.flush();
        this.currRecIdx = 0;
        ++this.currBlkIdx;
    }

    private final void initialize(int bsize, int rsize) {
        this.blkSize = bsize;
        this.recSize = rsize;
        this.recperblk = this.blkSize / this.recSize;
        this.blkBuffer = new byte[this.blkSize];
        if (this.is != null) {
            this.currBlkIdx = -1;
            this.currRecIdx = this.recperblk;
        } else {
            this.currBlkIdx = 0;
            this.currRecIdx = 0;
        }
    }

    public TarBuffer(InputStream is) {
        this.is = is;
        this.os = null;
        this.initialize(10240, 512);
    }

    public TarBuffer(OutputStream os) {
        this.is = null;
        this.os = os;
        this.initialize(10240, 512);
    }
}

