/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util.tar;

import java.io.File;
import java.util.Date;
import org.media.mn8.util.tar.TarHeader;

public class TarEntry {
    protected TarHeader header;
    protected File file;

    public String getName() {
        return this.header.name.toString();
    }

    public long getSize() {
        return this.header.size;
    }

    public void parseTarHeader(TarHeader hdr, byte[] header) throws Exception {
        int offset = 0;
        hdr.name = TarHeader.parseName(header, offset, 100);
        hdr.mode = (int)TarHeader.parseOctal(header, offset += 100, 8);
        hdr.userId = (int)TarHeader.parseOctal(header, offset += 8, 8);
        hdr.groupId = (int)TarHeader.parseOctal(header, offset += 8, 8);
        hdr.size = TarHeader.parseOctal(header, offset += 8, 12);
        hdr.modTime = TarHeader.parseOctal(header, offset += 12, 12);
        hdr.checkSum = (int)TarHeader.parseOctal(header, offset += 12, 8);
        offset += 8;
        hdr.linkFlag = header[offset++];
        hdr.linkName = TarHeader.parseName(header, offset, 100);
        hdr.magic = TarHeader.parseName(header, offset += 100, 8);
        hdr.userName = TarHeader.parseName(header, offset += 8, 32);
        hdr.groupName = TarHeader.parseName(header, offset += 32, 32);
        hdr.devMajor = (int)TarHeader.parseOctal(header, offset += 32, 8);
        hdr.devMinor = (int)TarHeader.parseOctal(header, offset += 8, 8);
    }

    public void nameTarHeader(TarHeader hdr, String name, int length) {
        boolean isDir = name.endsWith(File.separator);
        hdr.checkSum = 0;
        hdr.devMajor = 0;
        hdr.devMinor = 0;
        hdr.name = new StringBuffer(name);
        hdr.mode = isDir ? 16877 : 33188;
        hdr.userId = 0;
        hdr.groupId = 0;
        hdr.size = length;
        hdr.modTime = new Date().getTime() / 1000L;
        hdr.linkFlag = (byte)(isDir ? 53 : 48);
        hdr.linkName = new StringBuffer("");
        hdr.userName = new StringBuffer("");
        hdr.groupName = new StringBuffer("");
        hdr.magic = new StringBuffer("ustar");
    }

    public void writeEntryHeader(byte[] buf) {
        int offset = 0;
        long size = this.header.size;
        offset = TarHeader.getNameBytes(this.header.name, buf, offset, 100);
        offset = TarHeader.getOctalBytes(this.header.mode, buf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.userId, buf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.groupId, buf, offset, 8);
        offset = TarHeader.getLongOctalBytes(size, buf, offset, 12);
        int csOffset = offset = TarHeader.getLongOctalBytes(this.header.modTime, buf, offset, 12);
        int c = 0;
        while (c < 8) {
            buf[offset++] = 32;
            ++c;
        }
        buf[offset++] = this.header.linkFlag;
        offset = TarHeader.getNameBytes(this.header.linkName, buf, offset, 100);
        offset = TarHeader.getNameBytes(this.header.magic, buf, offset, 8);
        offset = TarHeader.getNameBytes(this.header.userName, buf, offset, 32);
        offset = TarHeader.getNameBytes(this.header.groupName, buf, offset, 32);
        offset = TarHeader.getOctalBytes(this.header.devMajor, buf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.devMinor, buf, offset, 8);
        while (offset < buf.length) {
            buf[offset++] = 0;
        }
        long checkSum = this.computeCheckSum(buf);
        TarHeader.getCheckSumOctalBytes(checkSum, buf, csOffset, 8);
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith(File.separator)) {
                return true;
            }
        }
        return false;
    }

    private final long computeCheckSum(byte[] buf) {
        long sum = 0L;
        int i = 0;
        while (i < buf.length) {
            sum += (long)(0xFF & buf[i]);
            ++i;
        }
        return sum;
    }

    private final void initialize() {
        this.file = null;
        this.header = new TarHeader();
    }

    public TarEntry(byte[] header) throws Exception {
        this.initialize();
        this.parseTarHeader(this.header, header);
    }

    public TarEntry(String name, int length) {
        this.initialize();
        this.nameTarHeader(this.header, name, length);
    }
}

