/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util.tar;

public class TarHeader {
    public static final int NAMELEN = 100;
    public static final int MODELEN = 8;
    public static final int UIDLEN = 8;
    public static final int GIDLEN = 8;
    public static final int CHKSUMLEN = 8;
    public static final int SIZELEN = 12;
    public static final int MAGICLEN = 8;
    public static final int MODTIMELEN = 12;
    public static final int UNAMELEN = 32;
    public static final int GNAMELEN = 32;
    public static final int DEVLEN = 8;
    public static final byte LF_OLDNORM = 0;
    public static final byte LF_NORMAL = 48;
    public static final byte LF_LINK = 49;
    public static final byte LF_SYMLINK = 50;
    public static final byte LF_CHR = 51;
    public static final byte LF_BLK = 52;
    public static final byte LF_DIR = 53;
    public static final byte LF_FIFO = 54;
    public static final byte LF_CONTIG = 55;
    public static final String TMAGIC = "ustar";
    public static final String GNU_TMAGIC = "ustar  ";
    public StringBuffer name;
    public int mode;
    public int userId;
    public int groupId;
    public long size;
    public long modTime;
    public int checkSum;
    public byte linkFlag;
    public StringBuffer linkName;
    public StringBuffer magic;
    public StringBuffer userName;
    public StringBuffer groupName;
    public int devMajor;
    public int devMinor;

    public static StringBuffer parseName(byte[] header, int offset, int length) throws Exception {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        int i = offset;
        while (i < end) {
            if (header[i] == 0) break;
            result.append((char)header[i]);
            ++i;
        }
        return result;
    }

    public static long parseOctal(byte[] header, int offset, int length) throws Exception {
        long result = 0L;
        boolean padding = true;
        int end = offset + length;
        int i = offset;
        while (i < end) {
            if (header[i] == 0) break;
            if (header[i] == 32 || header[i] == 48) {
                if (!padding) {
                    if (header[i] == 32) break;
                }
            } else {
                padding = false;
                result = (result << 3) + (long)(header[i] - 48);
            }
            ++i;
        }
        return result;
    }

    public static int getNameBytes(StringBuffer _name, byte[] buf, int offset, int length) {
        byte[] _buf = _name.toString().getBytes();
        int i = 0;
        while (i < length && i < _buf.length) {
            buf[offset + i] = _buf[i];
            ++i;
        }
        while (i < length) {
            buf[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    public static int getOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] result = new byte[length];
        int idx = length - 1;
        buf[offset + idx] = 0;
        buf[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buf[offset + idx] = 48;
            --idx;
        } else {
            long val = value;
            while (idx >= 0 && val > 0L) {
                buf[offset + idx] = (byte)(48 + (byte)(val & 7L));
                val >>= 3;
                --idx;
            }
        }
        while (idx >= 0) {
            buf[offset + idx] = 32;
            --idx;
        }
        return offset + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] temp = new byte[length + 1];
        TarHeader.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset, length);
        return offset + length;
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        TarHeader.getOctalBytes(value, buf, offset, length);
        buf[offset + length - 1] = 32;
        buf[offset + length - 2] = 0;
        return offset + length;
    }
}

