/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.media.mn8.util.tar.TarBuffer;
import org.media.mn8.util.tar.TarEntry;

public class TarInputStream
extends FilterInputStream {
    protected TarBuffer buffer;
    protected byte[] readBuf;
    protected byte[] oneBuf;
    protected boolean hasEOF;
    protected TarEntry currEntry;
    protected int entrySize;
    protected int entryOffset;

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        return this.entrySize - this.entryOffset;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public void skip(int nSkip) throws IOException {
        byte[] skipBuf = new byte[8192];
        int i = nSkip;
        while (i > 0) {
            int n = this.read(skipBuf, 0, i > skipBuf.length ? skipBuf.length : i);
            if (n == -1) break;
            i -= n;
        }
    }

    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        if (num == -1) {
            return num;
        }
        return this.oneBuf[0];
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int readed = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (length + this.entryOffset > this.entrySize) {
            length = this.entrySize - this.entryOffset;
        }
        if (this.readBuf != null) {
            int s = length > this.readBuf.length ? this.readBuf.length : length;
            System.arraycopy(this.readBuf, 0, buf, offset, s);
            if (s >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int _len = this.readBuf.length - s;
                byte[] _buf = new byte[_len];
                System.arraycopy(this.readBuf, s, _buf, 0, _len);
                this.readBuf = _buf;
            }
            readed += s;
            length -= s;
            offset += s;
        }
        while (length > 0) {
            byte[] rec = this.buffer.readRecord();
            if (rec == null) {
                throw new IOException("unexcepted EOF");
            }
            int _len = rec.length;
            int s = length;
            if (_len > s) {
                System.arraycopy(rec, 0, buf, offset, s);
                this.readBuf = new byte[_len - s];
                System.arraycopy(rec, s, this.readBuf, 0, _len - s);
            } else {
                s = _len;
                System.arraycopy(rec, 0, buf, offset, _len);
            }
            readed += s;
            length -= s;
            offset += s;
        }
        this.entryOffset += readed;
        return readed;
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] header;
        if (this.hasEOF) {
            return null;
        }
        if (this.currEntry != null) {
            int nSkip = this.entrySize + this.entryOffset;
            if (nSkip > 0) {
                this.skip(nSkip);
            }
            this.readBuf = null;
        }
        if ((header = this.buffer.readRecord()) == null) {
            this.hasEOF = true;
        } else if (this.buffer.isEOFRecord(header)) {
            this.hasEOF = true;
        }
        if (this.hasEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = new TarEntry(header);
                if (header[257] != 117 || header[258] != 115 || header[259] != 116 || header[260] != 97 || header[261] != 114) {
                    throw new IOException("header magic is not 'ustar'");
                }
                this.entryOffset = 0;
                this.entrySize = (int)this.currEntry.getSize();
            }
            catch (Exception ex) {
                this.entrySize = 0;
                this.entryOffset = 0;
                this.currEntry = null;
            }
        }
        return this.currEntry;
    }

    public TarInputStream(InputStream is) {
        super(is);
        this.buffer = new TarBuffer(is);
        this.readBuf = null;
        this.oneBuf = new byte[1];
        this.hasEOF = false;
    }
}

