/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.util.tar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.media.mn8.util.tar.TarBuffer;
import org.media.mn8.util.tar.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    protected TarBuffer buffer;
    protected byte[] recordBuf;
    protected byte[] oneBuf;
    protected int currByte;
    protected int currSize;
    protected int tempLen;
    protected byte[] tempBuf;

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public void close() throws IOException {
        this.writeEOFRecord();
        this.buffer.close();
    }

    public void write(int b) throws IOException {
        this.oneBuf[0] = (byte)b;
        this.write(this.oneBuf, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        if (this.currByte + length > this.currSize) {
            throw new IOException("You overstep the header size.");
        }
        if (this.tempLen > 0) {
            if (this.tempLen + length >= this.recordBuf.length) {
                int _len = this.recordBuf.length - this.tempLen;
                System.arraycopy(this.tempBuf, 0, this.recordBuf, 0, this.tempLen);
                System.arraycopy(buf, offset, this.recordBuf, this.tempLen, _len);
                this.buffer.writeRecord(this.recordBuf);
                this.currByte += this.recordBuf.length;
                offset += _len;
                length -= _len;
                this.tempLen = 0;
            } else {
                System.arraycopy(buf, offset, this.tempBuf, this.tempLen, length);
                offset += length;
                this.tempLen += length;
                length -= length;
            }
        }
        while (length > 0) {
            if (length < this.recordBuf.length) {
                System.arraycopy(buf, offset, this.tempBuf, this.tempLen, length);
                this.tempLen += length;
                break;
            }
            this.buffer.writeRecord(buf, offset);
            this.currByte += this.recordBuf.length;
            length -= this.recordBuf.length;
            offset += this.recordBuf.length;
        }
    }

    public void putNextEntry(TarEntry te) throws IOException {
        if (te.getName().length() > 100) {
            throw new IOException("File name '" + te.getName() + "' is too long ( > " + "100" + " bytes )");
        }
        te.writeEntryHeader(this.recordBuf);
        this.buffer.writeRecord(this.recordBuf);
        this.currByte = 0;
        this.currSize = te.isDirectory() ? 0 : (int)te.getSize();
    }

    public void closeEntry() throws IOException {
        if (this.tempLen > 0) {
            int i = this.tempLen;
            while (i < this.tempBuf.length) {
                this.tempBuf[i++] = 0;
            }
            this.buffer.writeRecord(this.tempBuf);
            this.currByte += this.tempLen;
            this.tempLen = 0;
        }
        if (this.currByte < this.currSize) {
            throw new IOException("Error durring when close entry.");
        }
    }

    private final void writeEOFRecord() throws IOException {
        int i = 0;
        while (i < this.recordBuf.length) {
            this.recordBuf[i++] = 0;
        }
        this.buffer.writeRecord(this.recordBuf);
    }

    public TarOutputStream(OutputStream os) {
        super(os);
        this.buffer = new TarBuffer(os);
        this.oneBuf = new byte[1];
        this.recordBuf = new byte[512];
        this.tempBuf = new byte[512];
        this.tempLen = 0;
    }
}

