/*
 * Decompiled with CFR 0.152.
 */
package org.media.naming;

import java.io.PrintWriter;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.media.naming.MemoryContext;

public final class MemoryBinding {
    public static final int INITIAL_CAPACITY = 11;
    public static final int MAXIMUM_CAPACITY = 191;
    public static final float LOAD_FACTOR = 0.75f;
    private String _name = "";
    protected MemoryBinding _parent;
    private int _count;
    private int _threshold = 8;
    private BindingEntry[] _hashTable = new BindingEntry[11];

    public final Context getContext() {
        return new MemoryContext(this, null);
    }

    public final synchronized Object get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        int hashCode = name.hashCode();
        int index = (hashCode & Integer.MAX_VALUE) % this._hashTable.length;
        BindingEntry entry = this._hashTable[index];
        while (entry != null) {
            if (entry._hashCode == hashCode && entry._name.equals(name)) {
                return entry._value;
            }
            entry = entry._next;
        }
        return null;
    }

    public final synchronized void put(String name, Object value) {
        int hashCode;
        int index;
        BindingEntry entry;
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null");
        }
        if (value instanceof MemoryBinding) {
            ((MemoryBinding)value)._parent = this;
            ((MemoryBinding)value)._name = name;
        }
        if ((entry = this._hashTable[index = ((hashCode = name.hashCode()) & Integer.MAX_VALUE) % this._hashTable.length]) == null) {
            this._hashTable[index] = entry = new BindingEntry(name, hashCode, value);
            ++this._count;
        } else {
            if (entry._hashCode == hashCode && entry._name.equals(name)) {
                entry._value = value;
                return;
            }
            BindingEntry next = entry._next;
            while (next != null) {
                if (next._hashCode == hashCode && next._name.equals(name)) {
                    next._value = value;
                    return;
                }
                entry = next;
                next = next._next;
            }
            entry._next = new BindingEntry(name, hashCode, value);
            ++this._count;
        }
        if (this._count >= this._threshold) {
            this.rehash();
        }
    }

    public final synchronized Object remove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        int hashCode = name.hashCode();
        int index = (hashCode & Integer.MAX_VALUE) % this._hashTable.length;
        BindingEntry entry = this._hashTable[index];
        if (entry == null) {
            return null;
        }
        if (entry._hashCode == hashCode && entry._name.equals(name)) {
            this._hashTable[index] = entry._next;
            --this._count;
            return entry._value;
        }
        BindingEntry next = entry._next;
        while (next != null) {
            if (next._hashCode == hashCode && next._name.equals(name)) {
                entry._next = next._next;
                --this._count;
                return next._value;
            }
            entry = next;
            next = next._next;
        }
        return null;
    }

    public final String getName() {
        if (this._parent != null && this._parent.getName().length() > 0) {
            return this._parent.getName() + "/" + this._name;
        }
        return this._name;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    public final boolean isEmpty() {
        return this._count == 0;
    }

    public final void destroy() {
        this._hashTable = null;
    }

    final void debug(PrintWriter writer) {
        this.debug(writer, 0);
    }

    private final synchronized void debug(PrintWriter writer, int level) {
        int j = level;
        while (j-- > 0) {
            writer.print("  ");
        }
        if (this instanceof MemoryBinding) {
            writer.println("MemoryBinding: " + this.getName());
        } else {
            writer.println("ThreadedBinding: " + this.getName());
        }
        if (this._count == 0) {
            writer.println("Empty");
        } else {
            int i = this._hashTable.length;
            while (i-- > 0) {
                BindingEntry entry = this._hashTable[i];
                while (entry != null) {
                    int j2 = level;
                    while (j2-- > 0) {
                        writer.print("  ");
                    }
                    Object value = entry._value;
                    if (value instanceof MemoryBinding) {
                        ((MemoryBinding)value).debug(writer, level + 1);
                        continue;
                    }
                    writer.println("  " + entry._name + " = " + value);
                }
            }
        }
    }

    protected final NamingEnumeration enumerate(Context context, boolean nameOnly) {
        return new MemoryBindingEnumeration(context, nameOnly);
    }

    private final void rehash() {
        int newSize = this._hashTable.length * 2 + 1;
        if (newSize > 191) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        BindingEntry[] newTable = new BindingEntry[newSize];
        int i = this._hashTable.length;
        while (i-- > 0) {
            BindingEntry entry = this._hashTable[i];
            while (entry != null) {
                BindingEntry next = entry._next;
                int index = (entry._hashCode & Integer.MAX_VALUE) % newSize;
                entry._next = newTable[index];
                newTable[index] = entry;
                entry = next;
            }
        }
        this._hashTable = newTable;
        this._threshold = (int)((float)newSize * 0.75f);
    }

    private static class BindingEntry {
        final String _name;
        final int _hashCode;
        Object _value;
        BindingEntry _next;

        BindingEntry(String name, int hashCode, Object value) {
            this._name = name;
            this._hashCode = hashCode;
            this._value = value;
        }
    }

    private final class MemoryBindingEnumeration
    implements NamingEnumeration {
        private BindingEntry _entry;
        private int _index;
        private final boolean _nameOnly;
        private final Context _context;
        private final String _contextClassName;
        private Object _nextValue;
        private String _nextName;
        private String _nextClassName;

        public final boolean hasMoreElements() {
            return this.hasMore();
        }

        public final Object nextElement() {
            return this.next();
        }

        public final void close() {
            this._entry = null;
            this._index = -1;
            this._nextValue = null;
            this._nextName = null;
            this._nextClassName = null;
        }

        public final boolean hasMore() {
            if (-1 == this._index) {
                return false;
            }
            if (this._nextName != null) {
                return true;
            }
            return this.internalHasMore();
        }

        public final Object next() throws NoSuchElementException {
            if (!this.hasMore()) {
                throw new NoSuchElementException("No more elements in enumeration");
            }
            String name = this._nextName;
            this._nextName = null;
            if (this._nameOnly) {
                return new NameClassPair(name, this._nextClassName, true);
            }
            Object value = this._nextValue;
            this._nextValue = null;
            return new Binding(name, this._nextClassName, value, true);
        }

        private final boolean internalHasMore() {
            BindingEntry entry = this.nextEntry();
            if (entry == null) {
                return false;
            }
            Object value = entry._value;
            if (value instanceof MemoryBinding) {
                if (this._nameOnly) {
                    this._nextClassName = this._contextClassName;
                } else {
                    try {
                        this._nextValue = this._context.lookup(entry._name);
                        this._nextClassName = this._nextValue.getClass().getName();
                    }
                    catch (NamingException except) {
                        return this.internalHasMore();
                    }
                }
                this._nextName = entry._name;
            } else if (value instanceof LinkRef) {
                try {
                    this._nextValue = this._context.lookup(entry._name);
                    this._nextClassName = this._nextValue == null ? null : this._nextValue.getClass().getName();
                }
                catch (NamingException except) {
                    return this.internalHasMore();
                }
                if (this._nameOnly) {
                    this._nextValue = null;
                }
                this._nextName = entry._name;
            } else if (value instanceof Reference) {
                if (!this._nameOnly) {
                    try {
                        this._nextValue = NamingManager.getObjectInstance(value, new CompositeName(entry._name), this._context, null);
                    }
                    catch (Exception except) {
                        return this.internalHasMore();
                    }
                }
                this._nextClassName = ((Reference)value).getClassName();
                this._nextName = entry._name;
            } else {
                if (!this._nameOnly) {
                    this._nextValue = value;
                }
                this._nextClassName = value == null ? null : value.getClass().getName();
                this._nextName = entry._name;
            }
            return true;
        }

        private final BindingEntry nextEntry() {
            BindingEntry entry = this._entry;
            if (entry != null) {
                this._entry = entry._next;
                return entry;
            }
            BindingEntry[] table = MemoryBinding.this._hashTable;
            int index = this._index;
            while (index > 0) {
                if ((entry = table[--index]) == null) continue;
                this._entry = entry._next;
                this._index = index;
                return entry;
            }
            return null;
        }

        MemoryBindingEnumeration(Context context, boolean nameOnly) {
            if (context == null) {
                throw new IllegalArgumentException("Argument context is null");
            }
            this._context = context;
            this._contextClassName = nameOnly ? context.getClass().getName() : null;
            this._nameOnly = nameOnly;
            this._index = MemoryBinding.this._hashTable.length;
        }
    }
}

