/*
 * Decompiled with CFR 0.152.
 */
package org.media.naming;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.media.naming.MemoryBinding;
import org.media.naming.MemoryContext;
import org.media.naming.MemoryContextFactory;

public class MemoryContext
implements Context {
    public static final String ReadOnly = "readOnly";
    public static final String NameSeparator = "/";
    public static final NameParser DefaultNameParser = new 1();
    private final MemoryBinding _bindings;
    private final Hashtable _env = new Hashtable();
    private boolean _readOnly;

    public Object lookup(String name) throws NamingException {
        Object object = this._bindings.get(name);
        if (object != null) {
            if (object instanceof LinkRef) {
                String link = ((LinkRef)object).getLinkName();
                if (link.startsWith(".")) {
                    return this.lookup(link.substring(1));
                }
                return NamingManager.getInitialContext(this._env).lookup(link);
            }
            if (object instanceof MemoryBinding) {
                return new MemoryContext((MemoryBinding)object, this._env);
            }
            if (object instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(object, new CompositeName(name), this, this._env);
                }
                catch (Exception except) {
                    throw new NamingException(except.toString());
                }
            }
            return object;
        }
        return this.internalLookup(new CompositeName(name), true);
    }

    public Object lookup(Name name) throws NamingException {
        return this.internalLookup(name, true);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.internalLookup(new CompositeName(name), false);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.internalLookup(name, false);
    }

    private final Object internalLookup(Name name, boolean resolveLinkRef) throws NamingException {
        Object object;
        MemoryBinding bindings;
        block11: {
            String link;
            bindings = this._bindings;
            while (true) {
                if (!name.isEmpty() && name.get(0).length() == 0) {
                    name = name.getSuffix(1);
                    continue;
                }
                if (name.isEmpty()) {
                    return new MemoryContext(bindings, this._env);
                }
                String simple = name.get(0);
                if (name.size() > 1) {
                    object = bindings.get(simple);
                    if (object instanceof Context) {
                        return ((Context)object).lookup(name.getSuffix(1));
                    }
                    if (!(object instanceof MemoryBinding)) {
                        throw new NotContextException(simple + " is not a subcontext");
                    }
                    bindings = (MemoryBinding)object;
                    name = name.getSuffix(1);
                    continue;
                }
                object = bindings.get(simple);
                if (object == null) {
                    throw new NameNotFoundException(simple + " not found");
                }
                if (!(object instanceof LinkRef) || !resolveLinkRef) break block11;
                link = ((LinkRef)object).getLinkName();
                if (!link.startsWith(".")) break;
                name = new CompositeName(link.substring(1));
            }
            return NamingManager.getInitialContext(this._env).lookup(link);
        }
        if (object instanceof MemoryBinding) {
            return new MemoryContext((MemoryBinding)object, this._env);
        }
        if (object instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(object, name, new MemoryContext(bindings, this._env), this._env);
            }
            catch (Exception except) {
                throw new NamingException(except.getMessage());
            }
        }
        return object;
    }

    public void bind(String name, Object value) throws NamingException {
        this.bind(new CompositeName(name), value);
    }

    public void bind(Name name, Object value) throws NamingException {
        if (this._readOnly) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (value instanceof MemoryContext) {
            value = ((MemoryContext)value)._bindings;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String simple = name.get(0);
        MemoryBinding bindings = this._bindings;
        while (name.size() > 1) {
            Object object = bindings.get(simple);
            if (object instanceof Context) {
                ((Context)object).bind(name.getSuffix(1), value);
                return;
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        MemoryBinding memoryBinding = bindings;
        synchronized (memoryBinding) {
            if (bindings.get(simple) != null) {
                throw new NameAlreadyBoundException(simple + " already bound, use rebind instead");
            }
            if (value instanceof Referenceable) {
                value = ((Referenceable)value).getReference();
            }
            bindings.put(simple, value);
        }
    }

    public void rebind(String name, Object value) throws NamingException {
        this.rebind(new CompositeName(name), value);
    }

    public void rebind(Name name, Object value) throws NamingException {
        if (this._readOnly) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (value instanceof MemoryContext) {
            value = ((MemoryContext)value)._bindings;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot rebind empty name");
        }
        String simple = name.get(0);
        MemoryBinding bindings = this._bindings;
        while (name.size() > 1) {
            Object object = bindings.get(simple);
            if (object instanceof Context) {
                ((Context)object).rebind(name.getSuffix(1), value);
                return;
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        MemoryBinding memoryBinding = bindings;
        synchronized (memoryBinding) {
            if (value instanceof Referenceable) {
                value = ((Referenceable)value).getReference();
            }
            bindings.put(simple, value);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    /*
     * Unable to fully structure code
     */
    public void unbind(Name name) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!name.isEmpty() && name.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        simple = name.get(0);
        bindings = this._bindings;
        while (name.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                ((Context)object).unbind(name.getSuffix(1));
                return;
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        var5_5 = bindings;
        synchronized (var5_5) {
            bindings.remove(simple);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    /*
     * Unable to fully structure code
     */
    public void rename(Name oldName, Name newName) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            oldName = oldName.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!oldName.isEmpty() && oldName.get((int)0).length() == 0)
        }
lbl5:
        // 2 sources

        while (!newName.isEmpty() && newName.get(0).length() == 0) {
            newName = newName.getSuffix(1);
        }
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        simple = newName.get(0);
        bindings = this._bindings;
        while (newName.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                ((Context)object).rename(newName.getSuffix(1), oldName);
                return;
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            newName = newName.getSuffix(1);
            simple = newName.get(0);
        }
        var6_6 = bindings;
        synchronized (var6_6) {
            if (bindings.get(simple) != null) {
                throw new NameAlreadyBoundException(simple + " already bound, use rebind to override");
            }
            if (oldName.size() == 1) {
                object = bindings.remove(oldName.get(0));
                if (object == null) {
                    throw new NameNotFoundException(oldName.get(0) + " not found");
                }
            } else {
                object = this.lookup(oldName);
                this.unbind(oldName);
            }
            bindings.put(simple, object);
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.length() == 0) {
            return this._bindings.enumerate(this, true);
        }
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return this._bindings.enumerate(this, true);
        }
        String simple = name.get(0);
        MemoryBinding bindings = this._bindings;
        while (name.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                return ((Context)object).list(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        if (simple.length() == 0) {
            return bindings.enumerate(this, true);
        }
        object = bindings.get(simple);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        if (object instanceof MemoryBinding) {
            return ((MemoryBinding)object).enumerate(this, true);
        }
        throw new NotContextException(simple + " is not a subcontext");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.length() == 0) {
            return this._bindings.enumerate(this, false);
        }
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return this._bindings.enumerate(this, false);
        }
        String simple = name.get(0);
        MemoryBinding bindings = this._bindings;
        while (name.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                return ((Context)object).listBindings(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        if (simple.length() == 0) {
            return bindings.enumerate(this, false);
        }
        object = bindings.get(simple);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        if (object instanceof MemoryBinding) {
            return ((MemoryBinding)object).enumerate(this, false);
        }
        throw new NotContextException(simple + " is not a subcontext");
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    /*
     * Unable to fully structure code
     */
    public Context createSubcontext(Name name) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!name.isEmpty() && name.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (name.isEmpty()) {
            throw new InvalidNameException("Subcontext name is empty");
        }
        simple = name.get(0);
        bindings = this._bindings;
        while (name.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                return ((Context)object).createSubcontext(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        var6_5 = bindings;
        synchronized (var6_5) {
            object = bindings.get(simple);
            if (object != null) {
                if (object instanceof Context) {
                    return (Context)((Context)object).lookup("");
                }
                if (object instanceof MemoryBinding) {
                    return new MemoryContext((MemoryBinding)object, this._env);
                }
                throw new NameAlreadyBoundException(simple + " already bound");
            }
            newBindings = new MemoryBinding();
            bindings.put(simple, newBindings);
            return new MemoryContext(newBindings, this._env);
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    /*
     * Unable to fully structure code
     */
    public void destroySubcontext(Name name) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!name.isEmpty() && name.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (name.isEmpty()) {
            throw new InvalidNameException("Subcontext name is empty");
        }
        simple = name.get(0);
        bindings = this._bindings;
        while (name.size() > 1) {
            object = bindings.get(simple);
            if (object instanceof Context) {
                ((Context)object).destroySubcontext(name.getSuffix(1));
                return;
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        var5_5 = bindings;
        synchronized (var5_5) {
            object = bindings.get(simple);
            if (object == null) {
                return;
            }
            if (object instanceof MemoryBinding) {
                if (!((MemoryBinding)object).isEmpty()) {
                    throw new ContextNotEmptyException(simple + " is not empty, cannot destroy");
                }
                ((MemoryBinding)object).destroy();
                bindings.remove(simple);
            } else if (object instanceof Context) {
                ((Context)object).close();
                bindings.remove(simple);
            } else {
                throw new NotContextException(simple + " is not a subcontext");
            }
        }
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (name.length() == 0) {
            return DefaultNameParser;
        }
        return this.getNameParser(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return DefaultNameParser;
        }
        String simple = name.get(0);
        MemoryBinding bindings = this._bindings;
        while (name.size() > 1) {
            Object object = bindings.get(simple);
            if (object instanceof Context) {
                return ((Context)object).getNameParser(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(simple + " is not a subcontext");
            }
            bindings = (MemoryBinding)object;
            name = name.getSuffix(1);
            simple = name.get(0);
        }
        return DefaultNameParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    public String composeName(String name, String prefix) {
        return prefix + NameSeparator + name;
    }

    public String getNameInNamespace() throws NamingException {
        return this._bindings.getName();
    }

    public Object addToEnvironment(String name, Object value) throws NamingException {
        if (name.equals(ReadOnly)) {
            boolean readOnly = value.toString().equalsIgnoreCase("true");
            if (this._readOnly && !readOnly) {
                throw new OperationNotSupportedException("Context is read-only");
            }
            this._readOnly = readOnly;
        }
        return this._env.put(name, value);
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public Object removeFromEnvironment(String name) {
        return this._env.remove(name);
    }

    public void close() {
        this._env.clear();
    }

    public String toString() {
        if (this._readOnly) {
            return this._bindings.getName() + " (read-only)";
        }
        return this._bindings.getName();
    }

    public MemoryBinding getBindings() {
        return this._bindings;
    }

    void debug(PrintWriter writer) {
        this._bindings.debug(writer);
    }

    public MemoryContext(Hashtable env) throws NamingException {
        if (env != null) {
            String name;
            Object value = env.get("java.naming.provider.url");
            this._bindings = value != null ? ((name = value.toString()).length() > 0 ? MemoryContextFactory.getBindings(name) : new MemoryBinding()) : new MemoryBinding();
            Enumeration enumeration = env.keys();
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                value = env.get(name);
                if (name.equals(ReadOnly)) {
                    this._readOnly = value.toString().equalsIgnoreCase("true");
                }
                this._env.put(name, value);
            }
        } else {
            this._bindings = new MemoryBinding();
        }
    }

    MemoryContext(MemoryBinding bindings, Hashtable env) {
        this._bindings = bindings;
        if (env != null) {
            Enumeration enumeration = env.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object value = env.get(name);
                if (name.equals(ReadOnly)) {
                    this._readOnly = value.toString().equalsIgnoreCase("true");
                }
                this._env.put(name, value);
            }
        }
    }
}

