/*
 * Decompiled with CFR 0.152.
 */
package org.media.naming;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.spi.InitialContextFactory;
import org.media.naming.MemoryBinding;
import org.media.naming.MemoryContext;

public final class MemoryContextFactory
implements InitialContextFactory {
    private static final MemoryBinding _root = new MemoryBinding();

    static final synchronized MemoryBinding getBindings(String path) throws NamingException {
        CompositeName name = new CompositeName(path);
        MemoryBinding binding = _root;
        int i = 0;
        while (i < name.size()) {
            if (name.get(i).length() > 0) {
                try {
                    MemoryBinding newBinding = (MemoryBinding)binding.get(name.get(i));
                    if (newBinding == null) {
                        newBinding = new MemoryBinding();
                        binding.put(name.get(i), newBinding);
                    }
                    binding = newBinding;
                }
                catch (ClassCastException except) {
                    throw new NotContextException(path + " does not specify a context");
                }
            }
            ++i;
        }
        return binding;
    }

    public final Context getInitialContext(Hashtable env) throws NamingException {
        String url = null;
        if (env.get("java.naming.provider.url") != null) {
            url = env.get("java.naming.provider.url").toString();
        }
        if (url == null || url.length() == 0) {
            return new MemoryContext(new MemoryBinding(), env);
        }
        return new MemoryContext(MemoryContextFactory.getBindings(url), env);
    }
}

