/*
 * Decompiled with CFR 0.152.
 */
package org.media.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class MemoryContextTest {
    private static Context _context;

    public static Context getContext() {
        return _context;
    }

    public static void main(String[] args) {
        MemoryContextTest mctx = new MemoryContextTest();
        Context ctx = MemoryContextTest.getContext();
        try {
            System.out.println("Name in name space: " + ctx.getNameInNamespace());
            NamingEnumeration<NameClassPair> nenum = ctx.list("");
            System.out.println("In context we have: ");
            while (nenum.hasMore()) {
                System.out.println("Object: " + ((Object)nenum.next()).toString());
            }
            Context sbctx = ctx.createSubcontext("env");
            System.out.println("created a subcontext with the name: env");
            nenum = ctx.list("");
            System.out.println("In context we have: ");
            while (nenum.hasMore()) {
                System.out.println("Object: " + ((Object)nenum.next()).toString());
            }
            Properties prop = System.getProperties();
            Enumeration<?> enumeration = prop.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                sbctx.rebind(name, (Object)prop.getProperty(name));
            }
            nenum = sbctx.list("");
            System.out.println("In context we have: ");
            while (nenum.hasMore()) {
                NameClassPair obj = nenum.next();
                System.out.println(obj.getName() + " ->" + sbctx.lookup(obj.getName()));
            }
            System.out.println("Name in name space: " + sbctx.getNameInNamespace());
        }
        catch (NamingException nex) {
            nex.printStackTrace();
            System.exit(0);
        }
    }

    public MemoryContextTest() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.media.naming.MemoryContextFactory");
        env.put("java.naming.provider.url", "env:/");
        try {
            _context = new InitialContext(env);
        }
        catch (NamingException nex) {
            nex.printStackTrace();
            System.exit(0);
        }
    }
}

