/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Blob {
    public static final String ABORT = "abort";
    public static final String COMPLETE = "complete";
    public static final String CONTINUE = "continue";
    public static final String NONE = "none";
    public static final int STATUS_NONE = 0;
    public static final int STATUS_ABORT = 1;
    public static final int STATUS_CONTINUE = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_LIMIT = 4;
    public static final int DEFAULT_BLOB_SIZE = 1024;
    public static final String ERR_INVALID_STATUS_VALUE = "Invalid SASL Status for Blob";
    public static final String ERR_MEANINGLESS_BLOB = "No valid data in blob";
    public static final String ERR_BASE64 = "Base64 encode or decode failure";
    public static final String ERR_XML_PARSE_FAILURE = "Failed to parse xml";
    public static final String FRAGMENT_ANGLE_SUFFIX = ">";
    public static final String FRAGMENT_BLOB_PREFIX = "<blob ";
    public static final String FRAGMENT_BLOB_SUFFIX = "</blob>";
    public static final String FRAGMENT_CDATA_PREFIX = "<![CDATA[";
    public static final String FRAGMENT_CDATA_SUFFIX = "]]>";
    public static final String FRAGMENT_ERROR_PREFIX = "<error ";
    public static final String FRAGMENT_ERROR_SUFFIX = "</error>";
    public static final String FRAGMENT_QUOTE_SUFFIX = "'";
    public static final String FRAGMENT_QUOTE_ANGLE_SUFFIX = "'>";
    public static final String FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX = "'/>";
    public static final String FRAGMENT_SLASH_ANGLE_SUFFIX = "/>";
    public static final String FRAGMENT_STATUS_PREFIX = "status='";
    public static final String TAG_BLOB = "blob";
    public static final String TAG_STATUS = "status";
    private static String[] statusMappings;
    private static BASE64Decoder decoder;
    private static BASE64Encoder encoder;
    private static DocumentBuilder builder;
    private static boolean initialized;
    private int status;
    private String blobData;
    private String stringified;
    private byte[] decodedData;

    public Blob(int n) throws SASLException {
        Log.logEntry((int)7, (String)("Created blob=>" + n));
        if (!initialized) {
            Blob.init();
        }
        if (!Blob.validateStatus(n)) {
            throw new SASLException(ERR_INVALID_STATUS_VALUE);
        }
        this.status = n;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(FRAGMENT_BLOB_PREFIX);
        if (n != 0) {
            stringBuffer.append(FRAGMENT_STATUS_PREFIX);
            stringBuffer.append(statusMappings[n]);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        }
        if (this.blobData == null) {
            stringBuffer.append(FRAGMENT_SLASH_ANGLE_SUFFIX);
        } else {
            stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
            stringBuffer.append(this.blobData);
            stringBuffer.append(FRAGMENT_BLOB_SUFFIX);
        }
        this.stringified = stringBuffer.toString();
        Log.logEntry((int)7, (String)("Created blob=>" + this.stringified));
    }

    public Blob(int n, String string) throws SASLException {
        Log.logEntry((int)7, (String)("Created blob=>" + n + "," + string));
        if (!initialized) {
            Blob.init();
        }
        if (!Blob.validateStatus(n)) {
            throw new SASLException(ERR_INVALID_STATUS_VALUE);
        }
        this.status = n;
        if (string != null) {
            try {
                this.decodedData = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 encoding not supported");
            }
            this.blobData = encoder.encodeBuffer(this.decodedData);
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(FRAGMENT_BLOB_PREFIX);
        if (n != 0) {
            stringBuffer.append(FRAGMENT_STATUS_PREFIX);
            stringBuffer.append(statusMappings[n]);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        }
        if (this.blobData == null) {
            stringBuffer.append(FRAGMENT_SLASH_ANGLE_SUFFIX);
        } else {
            stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
            stringBuffer.append(this.blobData);
            stringBuffer.append(FRAGMENT_BLOB_SUFFIX);
        }
        this.stringified = stringBuffer.toString();
        Log.logEntry((int)7, (String)("Created blob=>" + this.stringified));
    }

    public Blob(int n, byte[] byArray) throws SASLException {
        if (!initialized) {
            Blob.init();
        }
        if (!Blob.validateStatus(n)) {
            throw new SASLException(ERR_INVALID_STATUS_VALUE);
        }
        this.status = n;
        if (byArray != null) {
            this.decodedData = byArray;
            this.blobData = encoder.encodeBuffer(byArray);
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(FRAGMENT_BLOB_PREFIX);
        if (n != 0) {
            stringBuffer.append(FRAGMENT_STATUS_PREFIX);
            stringBuffer.append(statusMappings[n]);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        }
        if (this.blobData == null) {
            stringBuffer.append(FRAGMENT_SLASH_ANGLE_SUFFIX);
        } else {
            stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
            stringBuffer.append(this.blobData);
            stringBuffer.append(FRAGMENT_BLOB_SUFFIX);
        }
        this.stringified = stringBuffer.toString();
        Log.logEntry((int)7, (String)("Created blob=>" + this.stringified));
    }

    public Blob(String string) throws SASLException {
        Log.logEntry((int)7, (String)("Receiving blob of=>" + string));
        if (!initialized) {
            Blob.init();
        }
        this.stringified = string;
        String string2 = Blob.extractStatusFromBlob(string);
        this.status = 0;
        if (string2 != null) {
            int n = 0;
            while (n < 4) {
                if (statusMappings[n].equals(string2)) {
                    this.status = n;
                    break;
                }
                ++n;
            }
            string2 = statusMappings[this.status];
        }
        this.blobData = Blob.extractDataFromBlob(string);
        if (this.blobData != null) {
            try {
                this.decodedData = decoder.decodeBuffer(this.blobData);
            }
            catch (IOException iOException) {
                throw new SASLException(iOException.getMessage());
            }
        } else {
            this.decodedData = null;
        }
        if (this.status == 0 && this.blobData == null) {
            throw new SASLException(ERR_MEANINGLESS_BLOB);
        }
        Log.logEntry((int)7, (String)("Received Blob of =>" + this.stringified));
    }

    private static void init() throws SASLException {
        if (decoder == null) {
            decoder = new BASE64Decoder();
        }
        if (encoder == null) {
            encoder = new BASE64Encoder();
        }
        if (builder == null) {
            try {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SASLException(ERR_XML_PARSE_FAILURE);
            }
        }
        if (statusMappings == null) {
            statusMappings = new String[4];
            Blob.statusMappings[0] = NONE;
            Blob.statusMappings[1] = ABORT;
            Blob.statusMappings[2] = CONTINUE;
            Blob.statusMappings[3] = COMPLETE;
        }
        initialized = true;
    }

    public String getStatus() {
        return statusMappings[this.status];
    }

    public String getData() {
        if (this.decodedData == null) {
            return "";
        }
        return new String(this.decodedData);
    }

    public byte[] getDataBytes() {
        return this.decodedData;
    }

    public String toString() {
        return this.stringified;
    }

    private static Element processMessage(String string) throws SASLException {
        Document document = null;
        try {
            Log.logEntry((int)7, (String)"Tuning Profile Parse Routine");
            document = builder.parse(new ByteArrayInputStream(string.getBytes()));
            Log.logEntry((int)7, (String)"parsed message");
        }
        catch (Exception exception) {
            Log.logEntry((int)7, (Throwable)exception);
            throw new SASLException(ERR_XML_PARSE_FAILURE);
        }
        if (document == null) {
            throw new SASLException(ERR_XML_PARSE_FAILURE);
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new SASLException(ERR_XML_PARSE_FAILURE);
        }
        return element;
    }

    private static String extractStatusFromBlob(String string) throws SASLException {
        if (string == null || string.indexOf(FRAGMENT_BLOB_PREFIX) == -1) {
            return null;
        }
        Element element = Blob.processMessage(string);
        if (!element.getTagName().equals(TAG_BLOB)) {
            throw new SASLException(ERR_XML_PARSE_FAILURE);
        }
        return element.getAttribute(TAG_STATUS);
    }

    private static String extractDataFromBlob(String string) throws SASLException {
        if (string == null) {
            return null;
        }
        Element element = Blob.processMessage(string);
        if (!element.getTagName().equals(TAG_BLOB)) {
            throw new SASLException(ERR_XML_PARSE_FAILURE);
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return null;
        }
        return element.getFirstChild().getNodeValue();
    }

    private static String encodeData(String string) throws SASLException {
        try {
            return new String(encoder.encodeBuffer(string.getBytes()));
        }
        catch (Exception exception) {
            throw new SASLException(ERR_BASE64);
        }
    }

    private static boolean validateStatus(String string) {
        return string.equals(ABORT) || string.equals(NONE) || string.equals(CONTINUE) || string.equals(COMPLETE);
    }

    private static boolean validateStatus(int n) {
        return n >= 0 && n <= 3;
    }

    static {
        initialized = false;
    }
}

