/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl;

import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.SASLSessionTable;

public abstract class SASLProfile
extends TuningProfile {
    public static final String COMPLETE = "<blob status='complete'>";
    public static final String ERR_INVALID_SASL_STATUS = "Invalid SASL Status attribute value employed";
    public static final String ENCODING_NONE = "none";
    public static final String ENCODING_BASE64 = "base64";
    public static final String ENCODING_DEFAULT = "none";
    public static final String FRAGMENT_ERROR_PREFIX = "<error ";
    public static final String LOCALIZE_DEFAULT = "i-default";
    public static final String SASL = "sasl";
    public static final String SASL_STATUS_ABORT = "abort";
    public static final String SASL_STATUS_COMPLETE = "complete";
    public static final String SASL_STATUS_CONTINUE = "continue";
    public static final String SASL_STATUS_NONE = "none";
    protected SASLSessionTable sessionTable = new SASLSessionTable();

    protected static void clearCredential(Session session, SASLProfile sASLProfile) {
        try {
            TuningProfile.setLocalCredential((Session)session, null);
            TuningProfile.setPeerCredential((Session)session, null);
            if (sASLProfile != null) {
                sASLProfile.sessionTable.removeEntry(session);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finishInitiatorAuthentication(SessionCredential sessionCredential, Session session) {
        TuningProfile.setLocalCredential((Session)session, (SessionCredential)sessionCredential);
    }

    protected void finishListenerAuthentication(SessionCredential sessionCredential, Session session) throws SASLException {
        if (sessionCredential != null) {
            TuningProfile.setPeerCredential((Session)session, (SessionCredential)sessionCredential);
            this.sessionTable.addEntry(session);
        }
    }

    protected void failListenerAuthentication(Session session) {
        try {
            this.sessionTable.removeEntry(session);
            SASLProfile.clearCredential(session, null);
        }
        catch (SASLException sASLException) {
            // empty catch block
        }
    }
}

