/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionEvent;
import org.beepcore.beep.core.SessionEventListener;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.util.Log;

public class SASLSessionTable
implements SessionEventListener {
    private Hashtable nameToSession;
    private Hashtable sessionToName = new Hashtable(4);
    private static final int DEFAULT_SIZE = 4;
    private static final String ERR_INVALID_PARAMETERS = "Invalid parameters to Session Table call";
    private static final String MSG_SESSIONS_TABLE_HEADER = "===] BEEP Peer Session Table";
    private static final String MSG_EMPTY = "===]  NONE";
    private static final String MSG_MECHANISM_PREFIX = " Mechanism=>";
    private static final String MSG_USER_PREFIX = "===]  User=>";
    private static final String MSG_SESSIONS_TABLE_TRAILER = "===] End of Table";

    SASLSessionTable() {
        this.nameToSession = new Hashtable(4);
    }

    Session getSession(String string) throws SASLException {
        if (string == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        return (Session)this.nameToSession.get(string);
    }

    boolean isAuthenticated(String string) throws SASLException {
        if (string == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        return this.nameToSession.get(string) != null;
    }

    protected synchronized void addEntry(Session session) throws SASLException {
        boolean bl = false;
        if (session == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        SessionCredential sessionCredential = session.getPeerCredential();
        if (sessionCredential == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        bl = sessionCredential.getAuthenticatorType().equals("SASL/ANONYMOUS");
        String string = (String)this.sessionToName.get(session);
        if (bl) {
            this.sessionToName.remove(session);
        } else if (string != null) {
            this.sessionToName.remove(session);
            this.nameToSession.remove(string);
        }
        string = session.getPeerCredential().getAuthenticator();
        if (string == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        session.registerForEvent((SessionEventListener)this, 6);
        if (this.sessionToName.contains(session)) {
            this.nameToSession.remove(string);
        }
        this.sessionToName.put(session, string);
        if (!bl) {
            this.nameToSession.put(string, session);
        }
        this.printContents();
    }

    protected synchronized void removeEntry(Session session) throws SASLException {
        if (session == null) {
            throw new SASLException(ERR_INVALID_PARAMETERS);
        }
        if (session.getPeerCredential() != null) {
            String string = session.getPeerCredential().getAuthenticator();
            if (string == null) {
                throw new SASLException(ERR_INVALID_PARAMETERS);
            }
            this.nameToSession.remove(string);
        }
        this.sessionToName.remove(session);
        this.printContents();
    }

    public void receiveEvent(SessionEvent sessionEvent) {
        if (sessionEvent.getEvent() != 6) {
            return;
        }
        try {
            Session session = (Session)sessionEvent.getData();
            this.removeEntry(session);
        }
        catch (ClassCastException classCastException) {
        }
        catch (SASLException sASLException) {
            Log.logEntry((int)3, (Throwable)((Object)sASLException));
        }
    }

    void printContents() {
        Log.logEntry((int)7, (String)MSG_SESSIONS_TABLE_HEADER);
        if (this.sessionToName.size() == 0) {
            Log.logEntry((int)7, (String)MSG_EMPTY);
        } else {
            Enumeration enumeration = this.sessionToName.keys();
            while (enumeration.hasMoreElements()) {
                Session session = (Session)enumeration.nextElement();
                String string = (String)this.sessionToName.get(session);
                String string2 = session.getPeerCredential() != null ? session.getPeerCredential().getAuthenticatorType() : "UNKNOWN";
                Log.logEntry((int)7, (String)(MSG_USER_PREFIX + string + MSG_MECHANISM_PREFIX + string2));
            }
        }
        Log.logEntry((int)7, (String)MSG_SESSIONS_TABLE_TRAILER);
    }
}

