/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.anonymous;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.MessageListener;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.StringDataStream;
import org.beepcore.beep.profile.sasl.Blob;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.anonymous.SASLAnonymousProfile;
import org.beepcore.beep.util.Log;

class AnonymousAuthenticator
implements MessageListener,
ReplyListener {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_STARTED = 1;
    public static final int STATE_ID = 2;
    public static final int STATE_COMPLETE = 3;
    public static final int STATE_ABORT = 4;
    public static final String ERR_ANON_STATE = "Illegal state transition";
    public static final String ERR_PEER_ABORTED = "Our BEEP Peer has aborted this authentication sequence";
    public static final String ERR_IDENTITY_PARSE_FAILURE = "Invalid identity information submitted for Anonymous Authentication";
    public static final String ERR_UNEXPECTED_MESSAGE = "Unexpected SASL-Anonymous Message";
    private int state;
    private Channel channel;
    private Hashtable credential;
    private SASLAnonymousProfile profile;
    private String authenticated;

    AnonymousAuthenticator(SASLAnonymousProfile sASLAnonymousProfile) {
        Log.logEntry((int)7, (String)"Creating Listener ANONYMOUS Authenticator");
        this.credential = new Hashtable();
        this.profile = sASLAnonymousProfile;
        this.state = 0;
        this.credential.put("AUTHENTICATOR_TYPE", "SASL/ANONYMOUS");
    }

    void started(Channel channel) throws SASLException {
        Log.logEntry((int)7, (String)"Starting Anonymous Authenticator");
        if (this.state != 0) {
            throw new SASLException(ERR_ANON_STATE);
        }
        this.state = 1;
        channel.setDataListener((DataListener)this);
        this.channel = channel;
    }

    synchronized Blob receiveID(String string) throws SASLException {
        Log.logEntry((int)7, (String)"Anonymous Authenticator Receiving ID");
        if (this.state != 1) {
            this.abort(ERR_ANON_STATE);
        }
        if (string == null) {
            this.abort(ERR_IDENTITY_PARSE_FAILURE);
        }
        this.state = 2;
        this.credential.put("AUTHENTICATOR", string);
        this.credential.put("AUTHENTICATOR_TYPE", "SASL/ANONYMOUS");
        try {
            return new Blob(3);
        }
        catch (Exception exception) {
            this.abort("Failed to complete SASL Anonymous authentication");
            return null;
        }
    }

    void sendIdentity(String string) throws SASLException {
        Log.logEntry((int)7, (String)"Anonymous Authenticator sending Identity");
        if (string == null) {
            throw new SASLException(ERR_IDENTITY_PARSE_FAILURE);
        }
        Log.logEntry((int)7, (String)("Using=>" + string + "<="));
        Blob blob = new Blob(0, string);
        Log.logEntry((int)7, (String)("Using=>" + blob.toString() + "<="));
        try {
            this.credential.put("AUTHENTICATOR", string);
            this.channel.sendMSG((DataStream)new StringDataStream(blob.toString()), (ReplyListener)this);
        }
        catch (Exception exception) {
            this.abort(exception.getMessage());
        }
        this.state = 2;
    }

    synchronized SessionCredential receiveCompletion(String string) throws SASLException {
        Log.logEntry((int)7, (String)"Anonymous Authenticator Completing!");
        if (this.state != 2) {
            this.abort(ERR_ANON_STATE);
        }
        this.state = 3;
        return new SessionCredential(this.credential);
    }

    void abort(String string) throws SASLException {
        Log.logEntry((int)7, (String)"Aborting Anonymous Authenticator");
        Log.logEntry((int)7, (String)string);
        this.state = 4;
        throw new SASLException(string);
    }

    void abortNoThrow(String string) {
        Log.logEntry((int)7, (String)"Aborting Anonymous Authenticator");
        Log.logEntry((int)7, (String)string);
        this.state = 4;
    }

    public void receiveMSG(Message message) throws BEEPError {
        block10: {
            try {
                Object object;
                Log.logEntry((int)7, (String)"Anonymous Authenticator.receiveMSG");
                String string = null;
                Blob blob = null;
                if (this.state != 1) {
                    this.abort(ERR_ANON_STATE);
                }
                try {
                    object = message.getDataStream().getInputStream();
                    int n = ((InputStream)object).available();
                    byte[] byArray = new byte[n];
                    ((InputStream)object).read(byArray);
                    blob = new Blob(new String(byArray));
                    string = blob.getData();
                }
                catch (IOException iOException) {
                    Log.logEntry((int)3, (Throwable)iOException);
                    this.abort(iOException.getMessage());
                }
                Log.logEntry((int)7, (String)("MSG DATA=>" + string));
                object = blob.getStatus();
                if (object != null && ((String)object).equals("abort")) {
                    this.abort(ERR_PEER_ABORTED);
                }
                if (this.state != 1) break block10;
                try {
                    Blob blob2 = this.receiveID(string);
                    message.sendRPY((DataStream)new StringDataStream(blob2.toString()));
                }
                catch (BEEPException bEEPException) {
                    this.abort(bEEPException.getMessage());
                }
                this.profile.finishListenerAuthentication(new SessionCredential(this.credential), this.channel.getSession());
            }
            catch (SASLException sASLException) {
                try {
                    Blob blob = new Blob(1, ((Throwable)((Object)sASLException)).getMessage());
                    message.sendRPY((DataStream)new StringDataStream(blob.toString()));
                }
                catch (BEEPException bEEPException) {
                    message.getChannel().getSession().terminate(bEEPException.getMessage());
                }
            }
        }
    }

    public void receiveRPY(Message message) {
        Log.logEntry((int)7, (String)"Anonymous Authenticator.receiveRPY");
        Blob blob = null;
        boolean bl = true;
        try {
            Object object;
            if (this.state != 2) {
                this.abort(ERR_ANON_STATE);
            }
            try {
                object = message.getDataStream().getInputStream();
                int n = ((InputStream)object).available();
                byte[] byArray = new byte[n];
                ((InputStream)object).read(byArray);
                blob = new Blob(new String(byArray));
            }
            catch (IOException iOException) {
                this.abort(iOException.getMessage());
            }
            object = blob.getStatus();
            if (object != null && ((String)object).equals("abort")) {
                Log.logEntry((int)7, (String)("Anonymous Authenticator receiveRPY=>" + blob.getData()));
                bl = false;
                this.abort(ERR_PEER_ABORTED);
            }
            if (!((String)object).equals("abort")) {
                this.profile.finishInitiatorAuthentication(new SessionCredential(this.credential), this.channel.getSession());
                AnonymousAuthenticator anonymousAuthenticator = this;
                synchronized (anonymousAuthenticator) {
                    this.notify();
                }
                return;
            }
            this.abort(blob.getData());
        }
        catch (SASLException sASLException) {
            Log.logEntry((int)3, (Throwable)((Object)sASLException));
            AnonymousAuthenticator anonymousAuthenticator = this;
            synchronized (anonymousAuthenticator) {
                this.notify();
            }
            try {
                if (bl) {
                    Blob blob2 = new Blob(1, ((Throwable)((Object)sASLException)).getMessage());
                    this.channel.sendMSG((DataStream)new StringDataStream(blob.toString()), (ReplyListener)this);
                }
            }
            catch (Exception exception) {
                message.getChannel().getSession().terminate(exception.getMessage());
            }
        }
    }

    public void receiveERR(Message message) {
        Log.logEntry((int)7, (String)"Anonymous Authenticator.receiveERR");
        try {
            InputStream inputStream = message.getDataStream().getInputStream();
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            Log.logEntry((int)7, (String)("SASL-Anonymous Authentication ERR received=>\n" + new String(byArray)));
            this.abortNoThrow(new String(byArray));
            AnonymousAuthenticator anonymousAuthenticator = this;
            synchronized (anonymousAuthenticator) {
                this.notify();
            }
        }
        catch (Exception exception) {
            message.getChannel().getSession().terminate(exception.getMessage());
        }
    }

    public void receiveANS(Message message) {
        message.getChannel().getSession().terminate(ERR_UNEXPECTED_MESSAGE);
    }

    public void receiveNUL(Message message) {
        message.getChannel().getSession().terminate(ERR_UNEXPECTED_MESSAGE);
    }
}

