/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.anonymous;

import java.util.Hashtable;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.core.TuningResetException;
import org.beepcore.beep.profile.Profile;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.sasl.Blob;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.SASLProfile;
import org.beepcore.beep.profile.sasl.anonymous.AnonymousAuthenticator;
import org.beepcore.beep.util.Log;

public class SASLAnonymousProfile
extends SASLProfile
implements Profile,
StartChannelListener {
    public static final String uri = "http://iana.org/beep/SASL/ANONYMOUS";
    public static final String ANONYMOUS = "anonymous";
    public static final String MECHANISM = "SASL/ANONYMOUS";
    private static SASLAnonymousProfile instance = null;

    public SASLAnonymousProfile() {
        instance = this;
    }

    public StartChannelListener init(String string, ProfileConfiguration profileConfiguration) throws BEEPException {
        return this;
    }

    static synchronized SASLAnonymousProfile getInstance() {
        if (instance == null) {
            instance = new SASLAnonymousProfile();
        }
        return instance;
    }

    public void startChannel(Channel channel, String string, String string2) throws StartChannelException {
        Log.logEntry((int)7, (String)((Object)((Object)this)).getClass().toString(), (String)"SASLAnonymousProfile.startChannel");
        SASLProfile.clearCredential(channel.getSession(), this);
        Session session = channel.getSession();
        if (string2 != null) {
            try {
                Blob blob = new Blob(string2);
                string2 = blob.getData();
                Log.logEntry((int)7, (String)("SASLAnon...User claims to be=>" + string2));
                this.finishListenerAuthentication(SASLAnonymousProfile.generateCredential(string2), session);
                string2 = null;
                blob = new Blob(3, string2);
                TuningProfile.sendProfile((Session)session, (String)uri, (String)blob.toString(), (Channel)channel);
            }
            catch (Exception exception) {
                channel.getSession().terminate(exception.getMessage());
                return;
            }
            throw new TuningResetException("SASL ANON RESET");
        }
        try {
            AnonymousAuthenticator anonymousAuthenticator = new AnonymousAuthenticator(this);
            anonymousAuthenticator.started(channel);
            TuningProfile.sendProfile((Session)session, (String)uri, null, (Channel)channel);
        }
        catch (Exception exception) {
            channel.getSession().terminate(exception.getMessage());
            return;
        }
        throw new TuningResetException("SASL ANON RESET");
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
    }

    public boolean advertiseProfile(Session session) {
        return true;
    }

    public static Session AuthenticateSASLAnonymous(Session session, String string) throws BEEPException {
        if (string == null) {
            string = ANONYMOUS;
        }
        SASLProfile.clearCredential(session, null);
        AnonymousAuthenticator anonymousAuthenticator = new AnonymousAuthenticator(SASLAnonymousProfile.getInstance());
        Channel channel = session.startChannel(uri, (DataListener)anonymousAuthenticator);
        anonymousAuthenticator.started(channel);
        anonymousAuthenticator.sendIdentity(string);
        AnonymousAuthenticator anonymousAuthenticator2 = anonymousAuthenticator;
        synchronized (anonymousAuthenticator2) {
            try {
                anonymousAuthenticator.wait();
                Session session2 = channel.getSession();
                return session2;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return null;
    }

    public static Session AuthenticateSASLAnonymousPiggyback(Session session, String string) throws BEEPException {
        Blob blob;
        if (string == null) {
            string = ANONYMOUS;
        }
        SASLProfile.clearCredential(session, null);
        Channel channel = session.startChannel(uri, false, new Blob(0, string).toString(), null);
        Log.logEntry((int)7, (String)("Got start data of " + channel.getStartData()));
        if (channel.getStartData() != null && channel.getStartData().indexOf("<error ") != -1) {
            throw new BEEPException(channel.getStartData());
        }
        String string2 = channel.getStartData();
        if (string2 != null && (blob = new Blob(string2)).getStatus().equals("complete")) {
            SASLAnonymousProfile.getInstance().finishInitiatorAuthentication(SASLAnonymousProfile.generateCredential(string), channel.getSession());
            return session;
        }
        throw new BEEPException("Auth failed.");
    }

    static SessionCredential generateCredential() {
        return SASLAnonymousProfile.generateCredential(ANONYMOUS);
    }

    static SessionCredential generateCredential(String string) {
        if (string == null) {
            string = ANONYMOUS;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("AUTHENTICATOR", string);
        hashtable.put("AUTHENTICATOR_TYPE", MECHANISM);
        return new SessionCredential(hashtable);
    }

    protected void finishInitiatorAuthentication(SessionCredential sessionCredential, Session session) {
        super.finishInitiatorAuthentication(sessionCredential, session);
    }

    protected void finishListenerAuthentication(SessionCredential sessionCredential, Session session) throws SASLException {
        super.finishListenerAuthentication(sessionCredential, session);
    }
}

