/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.MessageListener;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.StringDataStream;
import org.beepcore.beep.profile.sasl.Blob;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.otp.OTPDictionary;
import org.beepcore.beep.profile.sasl.otp.OTPGenerator;
import org.beepcore.beep.profile.sasl.otp.SASLOTPProfile;
import org.beepcore.beep.profile.sasl.otp.SequenceZeroFailure;
import org.beepcore.beep.profile.sasl.otp.algorithm.Algorithm;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabase;
import org.beepcore.beep.util.Log;

class OTPAuthenticator
implements MessageListener,
ReplyListener {
    static final int STATE_UNKNOWN = 0;
    static final int STATE_STARTED = 1;
    static final int STATE_ID = 2;
    static final int STATE_CHALLENGE = 3;
    static final int STATE_RESPONSE = 4;
    static final int STATE_COMPLETE = 5;
    static final int STATE_ABORT = 6;
    static final String ERR_PEER_ABORTED = "Our BEEP Peer has aborted this authentication sequence";
    static final String ERR_IDENTITY_PARSE_FAILURE = "Invalid identity information submitted for OTP Authentication";
    static final String ERR_NULL_ID = "Invalid Authentication Info Provided";
    static final String ERR_OTP_AUTH_FAILURE = "Authentication Failure: Password hash doesn't match";
    static final String ERR_OTP_STATE = "Authentication Failure: Illegal OTP State Transition";
    static final String ERR_UNEXPECTED_MESSAGE = "Unexpected SASL-OTP Message";
    static final String ERR_INIT = "Error while parsing init-hex or init-word=>";
    static final String ERR_UNKNOWN_COMMAND = "Unknown SASL OTP Command=>";
    static final String ERR_CONCURRENT = "Authentication for that user already in progress";
    private static final String ERR_SEQUENCE_ZERO = "Authentication unable to proceed because the user's SASL OTP Sequence is 0.";
    private static String COLON = ":";
    static final String EXT = "ext";
    static final String HEX = "hex:";
    static final String INIT_HEX = "init-word:";
    static final String INIT_WORD = "init-hex:";
    static final String OTP_AUTH = "OTPAuthenticator";
    static final String SPACE = " ";
    static final String WORD = "word:";
    static final char SPACE_CHAR = ' ';
    private int state;
    private Algorithm algorithm;
    private Channel channel;
    private Hashtable credential;
    private SASLOTPProfile profile;
    private String authenticated;
    private String authorized;
    private String initData = null;
    private String password;
    private UserDatabase database;

    OTPAuthenticator(SASLOTPProfile sASLOTPProfile) {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"Creating Listener OTP Authenticator");
        this.authenticated = null;
        this.authorized = null;
        this.credential = new Hashtable();
        this.database = null;
        this.password = null;
        this.profile = sASLOTPProfile;
        this.state = 0;
        this.credential.put("AUTHENTICATOR_TYPE", "SASL/OTP");
    }

    void started(Channel channel) throws SASLException {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"Starting OTP Authenticator");
        if (this.state != 0) {
            throw new SASLException(ERR_OTP_STATE);
        }
        this.state = 1;
        this.channel = channel;
        this.channel.setDataListener((DataListener)this);
    }

    synchronized Blob receiveIDs(String string) throws SASLException {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator Receiving IDs");
        if (this.state != 1) {
            this.abort(ERR_OTP_STATE);
        }
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Data is" + string));
        char c = string.charAt(0);
        if (c == '\uffffffff') {
            this.abort(ERR_IDENTITY_PARSE_FAILURE);
        } else if (c == '\u0000') {
            this.authorized = null;
        } else {
            int n = 0;
            try {
                n = string.indexOf(0);
                this.authorized = string.substring(0, n);
            }
            catch (Exception exception) {
                this.authorized = null;
            }
        }
        this.authenticated = string.substring(string.indexOf(0) + 1);
        if (!this.profile.validateIdentity(this.authenticated, this)) {
            this.abort(ERR_CONCURRENT);
        }
        if (this.authenticated == null) {
            this.abort(ERR_NULL_ID);
        }
        Log.logEntry((int)7, (String)("Fetching DB for " + this.authenticated));
        try {
            this.database = SASLOTPProfile.getUserDatabase().getUser(this.authenticated);
            this.algorithm = SASLOTPProfile.getAlgorithm(this.database.getAlgorithmName());
        }
        catch (SASLException sASLException) {
            this.abort(((Throwable)((Object)sASLException)).getMessage());
        }
        this.credential.put("ALGORITHM", this.algorithm.getName());
        if (this.database.getSequence() == 0) {
            this.abort(ERR_SEQUENCE_ZERO);
        }
        this.state = 2;
        this.credential.put("AUTHENTICATOR", this.authenticated);
        if (this.authorized != null) {
            this.credential.put("AUTHORIZED", this.authorized);
        }
        this.credential.put("AUTHENTICATOR_TYPE", "SASL/OTP");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.algorithm.getName());
        stringBuffer.append(SPACE);
        stringBuffer.append(this.database.getSequence());
        stringBuffer.append(SPACE);
        stringBuffer.append(this.database.getSeed().toLowerCase());
        stringBuffer.append(SPACE);
        stringBuffer.append(EXT);
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Generated Challenge=>" + stringBuffer.toString()));
        try {
            return new Blob(0, stringBuffer.toString());
        }
        catch (Exception exception) {
            this.abort("Failed to issue SASL OTP challenge");
            return null;
        }
    }

    synchronized SessionCredential validateResponse(String string) throws SASLException {
        byte[] byArray;
        block10: {
            block9: {
                boolean bl = false;
                byArray = null;
                Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator validating response");
                if (this.state != 2) {
                    this.abort(ERR_OTP_STATE);
                }
                if (string.indexOf("hex-init:") != -1) break block9;
                if (string.indexOf("word-init:") == -1) break block10;
            }
            return this.validateInitResponse(string);
        }
        if (string.indexOf(WORD) != -1) {
            string = string.substring(WORD.length());
            long l = OTPDictionary.convertWordsToHash(string);
            byArray = SASLOTPProfile.convertLongToBytes(l);
            Log.logEntry((int)7, (String)OTP_AUTH, (String)("Hacked response=>" + string));
        } else if (string.indexOf(HEX) != -1) {
            string = string.substring(HEX.length());
            byArray = SASLOTPProfile.convertHexToBytes(string);
            Log.logEntry((int)7, (String)OTP_AUTH, (String)("Hacked response=>" + string));
        } else {
            this.abort(ERR_UNEXPECTED_MESSAGE);
        }
        if (this.database.getSequence() == 0) {
            throw new SequenceZeroFailure();
        }
        SessionCredential sessionCredential = this.validateHash(byArray);
        this.database.updateLastHash(SASLOTPProfile.convertBytesToHex(byArray));
        SASLOTPProfile.getUserDatabase().updateUserDB(this.database);
        return sessionCredential;
    }

    private SessionCredential validateHash(byte[] byArray) throws SASLException {
        if (this.database.getSequence() == 0) {
            throw new SequenceZeroFailure();
        }
        byte[] byArray2 = this.database.getLastHash();
        byte[] byArray3 = this.algorithm.generateHash(byArray);
        Log.logEntry((int)8, (String)("Test====>" + SASLOTPProfile.convertBytesToHex(byArray3)));
        Log.logEntry((int)8, (String)("Control=>" + SASLOTPProfile.convertBytesToHex(byArray2)));
        boolean bl = true;
        int n = 0;
        while (n < 8) {
            if (byArray2[n] != byArray3[n]) {
                bl = false;
            }
            ++n;
        }
        if (!bl) {
            throw new SASLException(ERR_OTP_AUTH_FAILURE);
        }
        this.state = 5;
        if (this.credential.size() == 0) {
            return null;
        }
        return new SessionCredential(this.credential);
    }

    synchronized SessionCredential validateInitResponse(String string) throws SASLException {
        Log.logEntry((int)7, (String)"Validating init-* response");
        byte[] byArray = null;
        int n = string.indexOf(COLON);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, COLON);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            Log.logEntry((int)7, (String)("Command=>" + string2));
            Log.logEntry((int)7, (String)("OldHashData=>" + string3));
            Log.logEntry((int)7, (String)("newParms=>" + string4));
            Log.logEntry((int)7, (String)("newHashData=>" + string5));
            Algorithm algorithm = SASLOTPProfile.getAlgorithm(this.database.getAlgorithmName());
            if ("hex-init:".startsWith(string2)) {
                Log.logEntry((int)7, (String)("CMD is " + "hex-init:"));
                byArray = SASLOTPProfile.convertHexToBytes(string3);
            } else if ("word-init:".startsWith(string2)) {
                Log.logEntry((int)7, (String)("CMD is " + "word-init:"));
                long l = OTPDictionary.convertWordsToHash(string3);
                byArray = SASLOTPProfile.convertLongToBytes(l);
            } else {
                this.abort(ERR_UNKNOWN_COMMAND + string2);
            }
            Log.logEntry((int)7, (String)("Retrieved from init-* oldHash=>" + SASLOTPProfile.convertBytesToHex(byArray)));
            SessionCredential sessionCredential = this.validateHash(byArray);
            stringTokenizer = new StringTokenizer(string4);
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            String string8 = stringTokenizer.nextToken().toLowerCase();
            if (!OTPGenerator.validateSeed(string8)) {
                this.abort("Invalid Seed");
            }
            stringTokenizer = new StringTokenizer(string4);
            Log.logEntry((int)7, (String)("Auth=>" + this.authenticated));
            Log.logEntry((int)7, (String)("Hash=>" + string5));
            SASLOTPProfile.getUserDatabase().addUser(this.authenticated, string6, string5, string8, string7);
            Log.logEntry((int)7, (String)"Successful Authentication!");
            return sessionCredential;
        }
        catch (Throwable throwable) {
            throw new SASLException(ERR_INIT + string + throwable.getMessage());
        }
    }

    OTPAuthenticator(SASLOTPProfile sASLOTPProfile, UserDatabase userDatabase, String string, String string2, String string3) {
        this.init(sASLOTPProfile, userDatabase, string, string2, string3);
    }

    private void init(SASLOTPProfile sASLOTPProfile, UserDatabase userDatabase, String string, String string2, String string3) {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator Initiator Construtor");
        this.authenticated = string3;
        this.authorized = string2;
        this.credential = new Hashtable();
        this.database = userDatabase;
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Dict.getA()" + this.database.getAlgorithmName()));
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Dict.getA()" + SASLOTPProfile.getAlgorithm(this.database.getAlgorithmName())));
        this.algorithm = SASLOTPProfile.getAlgorithm(this.database.getAlgorithmName());
        this.profile = sASLOTPProfile;
        this.password = string;
        this.state = 0;
        this.credential.put("AUTHENTICATOR_TYPE", "SASL/OTP");
        this.credential.put("ALGORITHM", this.algorithm.getName());
        this.credential.put("AUTHENTICATOR", string3);
        if (string2 != null) {
            this.credential.put("AUTHORIZED", string2);
        }
    }

    OTPAuthenticator(SASLOTPProfile sASLOTPProfile, UserDatabase userDatabase, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(COLON);
        stringBuffer.append(string4);
        stringBuffer.append(SPACE);
        stringBuffer.append(string7);
        stringBuffer.append(SPACE);
        stringBuffer.append(string6.toLowerCase());
        stringBuffer.append(COLON);
        stringBuffer.append(string5);
        this.initData = stringBuffer.toString();
        this.init(sASLOTPProfile, userDatabase, string, string2, string3);
    }

    void sendIdentity(String string, String string2) throws SASLException {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator sending Identities");
        int n = string2.length();
        if (string != null) {
            n += string.length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\u0000');
        }
        stringBuffer.append(string2);
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("AuthOTP Using=>" + stringBuffer.toString() + "<="));
        Blob blob = new Blob(0, stringBuffer.toString());
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("AuthOTP Using=>" + blob.toString() + "<="));
        try {
            this.channel.sendMSG((DataStream)new StringDataStream(blob.toString()), (ReplyListener)this);
        }
        catch (BEEPException bEEPException) {
            this.abort(bEEPException.getMessage());
        }
    }

    synchronized void receiveChallenge(Blob blob) throws SASLException {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator received Challenge");
        if (this.state != 1) {
            this.abortNoThrow(ERR_OTP_STATE);
        }
        if (blob.getStatus().equals("abort")) {
            this.abort(ERR_PEER_ABORTED);
        }
        String string = blob.getData();
        this.state = 3;
        int n = 0;
        String string2 = null;
        String string3 = null;
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Tokenizing=>" + string));
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 4) {
            this.abort("Failed to understand server's Challenge" + stringTokenizer.countTokens());
        }
        string3 = stringTokenizer.nextToken();
        this.algorithm = SASLOTPProfile.getAlgorithm(string3);
        if (this.algorithm == null) {
            this.abort("Unrecognized algorithm in server challenge");
        }
        n = Integer.parseInt(stringTokenizer.nextToken());
        string2 = stringTokenizer.nextToken().toLowerCase();
        if (!OTPGenerator.validateSeed(string2)) {
            this.abort("Invalid Seed");
        }
        Log.logEntry((int)7, (String)OTP_AUTH, (String)("Algo is=>" + string3 + " seed is=>" + string2 + " seq=>" + n));
        String string4 = new String(string2 + this.password);
        this.password = null;
        byte[] byArray = null;
        byte[] byArray2 = string4.getBytes();
        int n2 = 0;
        while (n2 < n) {
            byArray = this.algorithm.generateHash(byArray2);
            byArray2 = byArray;
            ++n2;
        }
        SASLOTPProfile.printHex(byArray2);
        long l = this.profile.convertBytesToLong(byArray2);
        string4 = new String(WORD + OTPDictionary.convertHashToWords(l));
        Log.logEntry((int)7, (String)("Prelim response is =>" + string4 + "<="));
        if (this.initData != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("hex-init:");
            stringBuffer.append(SASLOTPProfile.convertBytesToHex(byArray2));
            stringBuffer.append(this.initData);
            string4 = stringBuffer.toString();
            Log.logEntry((int)7, (String)("Produced INIT response of " + string4));
        }
        try {
            blob = new Blob(2, string4);
            this.channel.sendMSG((DataStream)new StringDataStream(blob.toString()), (ReplyListener)this);
        }
        catch (BEEPException bEEPException) {
            throw new SASLException("Unable to send response to challenge");
        }
    }

    synchronized SessionCredential receiveCompletion(String string) throws SASLException {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator Completing!");
        if (this.state != 3) {
            this.abort(ERR_OTP_STATE);
        }
        this.state = 5;
        return new SessionCredential(this.credential);
    }

    void abort(String string) throws SASLException {
        Log.logEntry((int)3, (String)OTP_AUTH, (String)("Aborting OTP Authenticator because " + string));
        this.state = 6;
        throw new SASLException(string);
    }

    void abortNoThrow(String string) {
        Log.logEntry((int)3, (String)OTP_AUTH, (String)("Aborting OTP Authenticator because " + string));
        this.state = 6;
    }

    public void receiveMSG(Message message) throws BEEPError {
        block13: {
            try {
                Object object;
                Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator.receiveMSG");
                String string = null;
                Blob blob = null;
                if (this.state != 1 && this.state != 2) {
                    this.abort(ERR_OTP_STATE);
                }
                try {
                    object = message.getDataStream().getInputStream();
                    int n = ((InputStream)object).available();
                    byte[] byArray = new byte[n];
                    ((InputStream)object).read(byArray);
                    blob = new Blob(new String(byArray));
                    string = blob.getData();
                }
                catch (IOException iOException) {
                    this.abort(iOException.getMessage());
                }
                Log.logEntry((int)7, (String)OTP_AUTH, (String)("MSG DATA=>" + string));
                object = blob.getStatus();
                if (object != null && ((String)object).equals("abort")) {
                    this.abort(ERR_PEER_ABORTED);
                }
                if (this.state == 1) {
                    Blob blob2 = this.receiveIDs(string);
                    try {
                        message.sendRPY((DataStream)new StringDataStream(blob2.toString()));
                    }
                    catch (BEEPException bEEPException) {
                        throw new SASLException(bEEPException.getMessage());
                    }
                    return;
                }
                SessionCredential sessionCredential = null;
                sessionCredential = this.validateResponse(string);
                if (sessionCredential == null) break block13;
                this.profile.finishListenerAuthentication(sessionCredential, this.channel.getSession());
                this.state = 5;
                Log.logEntry((int)7, (String)OTP_AUTH, (String)("Wow, cool!!! " + this.channel.getSession() + " is valid for\n" + sessionCredential.toString()));
                try {
                    message.sendRPY((DataStream)new StringDataStream(new Blob(3).toString()));
                    this.channel.setDataListener(null);
                }
                catch (BEEPException bEEPException) {
                    this.profile.failListenerAuthentication(this.channel.getSession(), this.authenticated);
                    this.abortNoThrow(bEEPException.getMessage());
                    message.getChannel().getSession().terminate(bEEPException.getMessage());
                    return;
                }
            }
            catch (SASLException sASLException) {
                try {
                    this.profile.failListenerAuthentication(this.channel.getSession(), this.authenticated);
                    Blob blob = new Blob(1, ((Throwable)((Object)sASLException)).getMessage());
                    message.sendRPY((DataStream)new StringDataStream(blob.toString()));
                }
                catch (BEEPException bEEPException) {
                    message.getChannel().getSession().terminate(((Throwable)((Object)sASLException)).getMessage());
                }
            }
        }
    }

    public void receiveRPY(Message message) {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator.receiveRPY");
        Blob blob = null;
        boolean bl = true;
        try {
            Object object;
            if (this.state != 1 && this.state != 3 && this.state != 5) {
                bl = true;
            }
            try {
                object = message.getDataStream().getInputStream();
                int n = ((InputStream)object).available();
                byte[] byArray = new byte[n];
                ((InputStream)object).read(byArray);
                blob = new Blob(new String(byArray));
            }
            catch (IOException iOException) {
                this.abort(iOException.getMessage());
            }
            object = blob.getStatus();
            if (object != null && ((String)object).equals("abort")) {
                Log.logEntry((int)7, (String)OTP_AUTH, (String)("OTPAuthenticator receiveRPY got an RPY=>" + blob.getData()));
                bl = false;
                this.abort(ERR_PEER_ABORTED + blob.getData());
            }
            if (this.state == 1) {
                this.receiveChallenge(blob);
                return;
            }
            if (blob.getStatus() != "abort") {
                this.profile.finishInitiatorAuthentication(new SessionCredential(this.credential), this.channel.getSession());
                OTPAuthenticator oTPAuthenticator = this;
                synchronized (oTPAuthenticator) {
                    this.notify();
                }
                return;
            }
            this.abort(ERR_UNKNOWN_COMMAND);
            return;
        }
        catch (Exception exception) {
            Log.logEntry((int)3, (Throwable)exception);
            OTPAuthenticator oTPAuthenticator = this;
            synchronized (oTPAuthenticator) {
                this.notify();
            }
            if (bl) {
                try {
                    Blob blob2 = new Blob(1, exception.getMessage());
                    this.channel.sendMSG((DataStream)new StringDataStream(blob2.toString()), (ReplyListener)this);
                }
                catch (BEEPException bEEPException) {
                    message.getChannel().getSession().terminate(bEEPException.getMessage());
                }
            }
            return;
        }
    }

    public void receiveERR(Message message) {
        Log.logEntry((int)7, (String)OTP_AUTH, (String)"OTP Authenticator.receiveERR");
        try {
            InputStream inputStream = message.getDataStream().getInputStream();
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            Blob blob = new Blob(new String(byArray));
            Log.logEntry((int)7, (String)OTP_AUTH, (String)("ERR received=>\n" + blob.getData()));
            this.abort(new String(byArray));
            OTPAuthenticator oTPAuthenticator = this;
            synchronized (oTPAuthenticator) {
                this.notify();
            }
        }
        catch (Exception exception) {
            this.abortNoThrow(exception.getMessage());
        }
    }

    public void receiveANS(Message message) {
        message.getChannel().getSession().terminate(ERR_UNEXPECTED_MESSAGE);
    }

    public void receiveNUL(Message message) {
        message.getChannel().getSession().terminate(ERR_UNEXPECTED_MESSAGE);
    }
}

