/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.otp.SASLOTPProfile;
import org.beepcore.beep.profile.sasl.otp.algorithm.Algorithm;

public class OTPGenerator {
    private static final String PROMPT_ALGORITHM = "Please enter the hash algorithm to use";
    private static final String PROMPT_ALGORITHM_SUGGESTIONS = " [ Please use 'otp-md5' or 'otp-sha1' ]";
    private static final String PROMPT_PASSPHRASE = "Please enter the passphrase to be used (this will NOT be stored)";
    private static final String PROMPT_RETURN = " and hit return when done\n=>";
    private static final String PROMPT_SEED = "Please enter some string to serve as your password seed:";
    private static final String PROMPT_SEQUENCE = "Please enter an integer corresponding to the OTP sequence you wish to use:";
    private static final String PROMPT_USERNAME = "Please enter the username to be used in authentication";
    private static final String ERR_USER_DB_EXISTS = "User database exists for ";
    private static final String ERR_ALGO_UNSUPPORTED = "Algorithm not supported=>";
    private static final String ERR_SEED_ALPHANUM = "Seed must be composed of alpha-numeric characters only.";
    private static final String ERR_SEED_SIZE = "Seed must 1 to 16 characters in length.";
    private static final String ERR_PASSPHRASE_SIZE = "Passphrase must be between 10 and 63 characters in length";

    private static String getUserInput() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String promptForAlgorithm() {
        boolean bl = false;
        String string = null;
        while (!bl) {
            System.out.println(PROMPT_ALGORITHM);
            System.out.println(PROMPT_ALGORITHM_SUGGESTIONS);
            System.out.print(PROMPT_RETURN);
            string = OTPGenerator.getUserInput();
            Algorithm algorithm = SASLOTPProfile.getAlgorithm(string);
            if (algorithm == null) {
                System.out.println(ERR_ALGO_UNSUPPORTED + string);
                continue;
            }
            bl = true;
        }
        return string;
    }

    private static String promptForPassphrase() {
        boolean bl = false;
        String string = null;
        while (!bl) {
            System.out.println(PROMPT_PASSPHRASE);
            System.out.print(PROMPT_RETURN);
            string = OTPGenerator.getUserInput();
            try {
                bl = OTPGenerator.validatePassphrase(string);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return string;
    }

    private static String promptForSeed() {
        boolean bl = false;
        String string = null;
        while (!bl) {
            System.out.println(PROMPT_SEED);
            System.out.print(PROMPT_RETURN);
            string = OTPGenerator.getUserInput();
            try {
                bl = OTPGenerator.validateSeed(string);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return string.toLowerCase();
    }

    private static String promptForSequence() {
        boolean bl = false;
        String string = null;
        while (!bl) {
            System.out.println(PROMPT_SEQUENCE);
            System.out.print(PROMPT_RETURN);
            string = OTPGenerator.getUserInput();
            bl = OTPGenerator.validateSequence(string);
        }
        return string;
    }

    private static String promptForUsername() {
        System.out.println(PROMPT_USERNAME);
        System.out.print(PROMPT_RETURN);
        return OTPGenerator.getUserInput();
    }

    private static boolean validateUserName(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(string + ".otp"));
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    static boolean validatePassphrase(String string) throws SASLException {
        int n = string.length();
        if (n < 10 || n > 63) {
            System.out.println("The length of " + n + " is invalid.");
            throw new SASLException(ERR_PASSPHRASE_SIZE);
        }
        return true;
    }

    static boolean validateSeed(String string) throws SASLException {
        int n = string.length();
        if (n <= 0 || n > 10) {
            System.out.println("The length of " + n + " is invalid.");
            throw new SASLException(ERR_SEED_SIZE);
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isDigit(c) && !Character.isLetter(c)) {
                System.out.println("The character=>" + string.charAt(n2) + "<= is invalid.");
                throw new SASLException(ERR_SEED_ALPHANUM);
            }
            ++n2;
        }
        return true;
    }

    static boolean validateSequence(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
            return n >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) throws SASLException {
        SASLOTPProfile sASLOTPProfile = new SASLOTPProfile();
        try {
            sASLOTPProfile.init("http://iana.org/beep/SASL/OTP", new ProfileConfiguration());
        }
        catch (BEEPException bEEPException) {
            // empty catch block
        }
        Properties properties = new Properties();
        String string = null;
        while (!OTPGenerator.validateUserName(string = OTPGenerator.promptForUsername())) {
        }
        String string2 = null;
        string2 = OTPGenerator.promptForPassphrase();
        String string3 = OTPGenerator.promptForSeed();
        String string4 = OTPGenerator.promptForAlgorithm();
        String string5 = OTPGenerator.promptForSequence();
        Algorithm algorithm = SASLOTPProfile.getAlgorithm(string4);
        int n = Integer.parseInt(string5);
        byte[] byArray = algorithm.generateHash(string3 + string2);
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray2 = algorithm.generateHash(byArray);
            byArray = byArray2;
            ++n2;
        }
        SASLOTPProfile.printHex(byArray);
        string2 = SASLOTPProfile.convertBytesToHex(byArray);
        try {
            ((Hashtable)properties).put("OTP Authenticator", string);
            ((Hashtable)properties).put("OTP Algorithm", string4);
            ((Hashtable)properties).put("OTP Last Hash", string2);
            ((Hashtable)properties).put("OTP Sequence", string5);
            ((Hashtable)properties).put("OTP Seed", string3);
            properties.store(new FileOutputStream(string + ".otp"), "OTP Properties Header");
        }
        catch (Exception exception) {
            throw new SASLException(exception.getMessage());
        }
    }

    static void storeUserDb(String string, String string2, String string3, String string4, String string5, int n, int n2) throws SASLException {
        if (!OTPGenerator.validateUserName(string)) {
            throw new SASLException(ERR_USER_DB_EXISTS);
        }
        try {
            string5 = string5.toLowerCase();
            OTPGenerator.validateSeed(string5);
        }
        catch (Exception exception) {
            throw new SASLException(exception.getMessage());
        }
        Properties properties = new Properties();
        try {
            ((Hashtable)properties).put("OTP Authenticator", string);
            ((Hashtable)properties).put("OTP Algorithm", string2);
            ((Hashtable)properties).put("OTP Last Hash", string3);
            ((Hashtable)properties).put("OTP Sequence", Integer.toString(n2));
            ((Hashtable)properties).put("OTP Seed", string5);
            properties.store(new FileOutputStream(string + ".otp"), "OTP Properties Header");
        }
        catch (Exception exception) {
            throw new SASLException(exception.getMessage());
        }
    }
}

