/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp;

import java.util.Hashtable;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.core.TuningResetException;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.sasl.Blob;
import org.beepcore.beep.profile.sasl.InvalidParameterException;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.SASLProfile;
import org.beepcore.beep.profile.sasl.otp.OTPAuthenticator;
import org.beepcore.beep.profile.sasl.otp.OTPGenerator;
import org.beepcore.beep.profile.sasl.otp.algorithm.Algorithm;
import org.beepcore.beep.profile.sasl.otp.algorithm.md5.MD5;
import org.beepcore.beep.profile.sasl.otp.algorithm.sha1.SHA1;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabase;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabasePool;
import org.beepcore.beep.util.Log;

public class SASLOTPProfile
extends SASLProfile
implements StartChannelListener {
    public static final String URI = "http://iana.org/beep/SASL/OTP";
    public static final String EXT = "ext";
    public static final String HEX = "hex:";
    public static final String SPACE = " ";
    public static final String WORD = "word:";
    public static final String HEX_INIT = "hex-init:";
    public static final String OTP_DB_FILENAME = "OTP_DB";
    public static final String SASL_OTP = "SASLOTPProfile";
    public static final String WORD_INIT = "word-init:";
    public static final String MECHANISM = "SASL/OTP";
    public static final String ERR_PARSING_DB = "Error parsing OTP DB";
    public static final String ERR_REJECTED = "Peer rejected SASL-OTP Start Channel Request";
    public static final String ERR_INVALID_ID = "Invalid or improperly formatted Identity information";
    private Hashtable authenticators;
    private MD5 md5;
    private SHA1 sha1;
    private static Hashtable algorithms;
    private static SASLOTPProfile instance;
    private static UserDatabasePool userDatabase;

    public StartChannelListener init(String string, ProfileConfiguration profileConfiguration) throws BEEPException {
        this.md5 = new MD5();
        this.sha1 = new SHA1();
        this.authenticators = new Hashtable();
        if (instance == null) {
            instance = this;
            algorithms = new Hashtable();
            algorithms.put(MD5.getAlgorithmName(), this.md5);
            algorithms.put(SHA1.getAlgorithmName(), this.sha1);
            userDatabase = new UserDatabasePool();
        }
        return this;
    }

    static SASLOTPProfile instance() throws SASLException {
        if (instance == null) {
            throw new SASLException("SASLOTPProfile uninitialized");
        }
        return instance;
    }

    static UserDatabasePool getUserDatabase() {
        return userDatabase;
    }

    static Algorithm getAlgorithm(String string) {
        Object v = algorithms.get(string);
        if (v != null) {
            return (Algorithm)v;
        }
        return null;
    }

    public void startChannel(Channel channel, String string, String string2) throws StartChannelException {
        Blob blob = null;
        SASLProfile.clearCredential(channel.getSession(), this);
        String string3 = null;
        Log.logEntry((int)7, (String)SASL_OTP, (String)"SASL-OTP Start Channel CCL");
        OTPAuthenticator oTPAuthenticator = new OTPAuthenticator(this);
        try {
            if (string2 != null) {
                oTPAuthenticator.started(channel);
                blob = new Blob(string2);
                string2 = blob.getData();
                try {
                    blob = oTPAuthenticator.receiveIDs(string2);
                    Log.logEntry((int)7, (String)SASL_OTP, (String)("Challenge is=>" + string3));
                }
                catch (SASLException sASLException) {
                    oTPAuthenticator.abortNoThrow(((Throwable)((Object)sASLException)).getMessage());
                    blob = new Blob(1, ((Throwable)((Object)sASLException)).getMessage());
                    return;
                }
                Log.logEntry((int)7, (String)SASL_OTP, (String)("Blobbed64 Challenge is=>" + string2));
            }
            channel.setDataListener((DataListener)oTPAuthenticator);
            if (blob != null) {
                TuningProfile.sendProfile((Session)channel.getSession(), (String)URI, (String)blob.toString(), (Channel)channel);
            } else {
                TuningProfile.sendProfile((Session)channel.getSession(), (String)URI, null, (Channel)channel);
            }
            if (blob == null) {
                oTPAuthenticator.started(channel);
            }
            Log.logEntry((int)7, (String)"Started an SASL-OTP Channel");
        }
        catch (Exception exception) {
            channel.getSession().terminate(exception.getMessage());
            return;
        }
        throw new TuningResetException("SASL ANON RESET");
    }

    public boolean advertiseProfile(Session session) {
        return true;
    }

    protected synchronized boolean validateIdentity(String string, OTPAuthenticator oTPAuthenticator) throws SASLException {
        if (this.authenticators.get(string) != null) {
            return false;
        }
        this.authenticators.put(string, oTPAuthenticator);
        return true;
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
    }

    public StartChannelListener getStartChannelListener() {
        return this;
    }

    OTPAuthenticator startAuthentication(String string, String string2, String string3) throws SASLException {
        UserDatabase userDatabase = SASLOTPProfile.userDatabase.getUser(string2);
        if (userDatabase == null) {
            throw new SASLException("User OTP data not found");
        }
        OTPAuthenticator oTPAuthenticator = new OTPAuthenticator(this, userDatabase, string3, string, string2);
        return oTPAuthenticator;
    }

    OTPAuthenticator startAuthentication(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SASLException {
        UserDatabase userDatabase = SASLOTPProfile.userDatabase.getUser(string2);
        if (userDatabase == null) {
            throw new SASLException("User OTP data not found");
        }
        string6 = string6.toLowerCase();
        OTPAuthenticator oTPAuthenticator = new OTPAuthenticator(this, userDatabase, string3, string, string2, string4, string5, string6, string7);
        return oTPAuthenticator;
    }

    protected void finishInitiatorAuthentication(SessionCredential sessionCredential, Session session) {
        super.finishInitiatorAuthentication(sessionCredential, session);
    }

    protected void finishListenerAuthentication(SessionCredential sessionCredential, Session session) throws SASLException {
        super.finishListenerAuthentication(sessionCredential, session);
        this.authenticators.remove(sessionCredential.getAuthenticator());
    }

    protected void failListenerAuthentication(Session session, String string) {
        this.authenticators.remove(string);
        super.failListenerAuthentication(session);
    }

    public static Session AuthenticateSASLOTP(Session session, String string, String string2, String string3) throws SASLException {
        boolean bl = false;
        if (string2 == null || session == null || string3 == null) {
            Log.logEntry((int)3, (String)SASL_OTP, (String)(ERR_INVALID_ID + string2));
            throw new InvalidParameterException(ERR_INVALID_ID + string2);
        }
        SASLProfile.clearCredential(session, null);
        OTPAuthenticator oTPAuthenticator = SASLOTPProfile.instance().startAuthentication(string, string2, string3);
        Channel channel = null;
        String string4 = null;
        try {
            channel = session.startChannel(URI, false, null, (DataListener)oTPAuthenticator);
            string4 = channel.getStartData();
        }
        catch (BEEPException bEEPException) {
            oTPAuthenticator.abort(bEEPException.getMessage());
        }
        Blob blob = null;
        if (string4 != null && (blob = new Blob(string4)).getStatus().equals("abort")) {
            throw new SASLException(ERR_REJECTED);
        }
        oTPAuthenticator.started(channel);
        oTPAuthenticator.sendIdentity(string, string2);
        try {
            OTPAuthenticator oTPAuthenticator2 = oTPAuthenticator;
            synchronized (oTPAuthenticator2) {
                oTPAuthenticator.wait();
                SessionCredential sessionCredential = session.getLocalCredential();
                if (sessionCredential == null) {
                    oTPAuthenticator.abort("Authentication Failed");
                } else {
                    bl = true;
                    Log.logEntry((int)7, (String)SASL_OTP, (String)("Wow, cool!!! " + session + " is valid for\n" + sessionCredential.toString()));
                }
            }
        }
        catch (Exception exception) {
            oTPAuthenticator.abort(exception.getMessage());
        }
        return session;
    }

    public static Session AuthenticateSASLOTPPiggybacked(Session session, String string, String string2, String string3) throws SASLException {
        boolean bl = false;
        if (string2 == null) {
            Log.logEntry((int)3, (String)SASL_OTP, (String)(ERR_INVALID_ID + string2));
            throw new InvalidParameterException(ERR_INVALID_ID + string2);
        }
        SASLProfile.clearCredential(session, null);
        OTPAuthenticator oTPAuthenticator = SASLOTPProfile.instance().startAuthentication(string, string2, string3);
        Channel channel = null;
        String string4 = null;
        try {
            channel = session.startChannel(URI, false, null, (DataListener)oTPAuthenticator);
            string4 = channel.getStartData();
        }
        catch (BEEPException bEEPException) {
            oTPAuthenticator.abort(bEEPException.getMessage());
        }
        Blob blob = null;
        if (string4 != null && (blob = new Blob(string4)).getStatus().equals("abort")) {
            throw new SASLException(ERR_REJECTED);
        }
        oTPAuthenticator.started(channel);
        oTPAuthenticator.sendIdentity(string, string2);
        try {
            OTPAuthenticator oTPAuthenticator2 = oTPAuthenticator;
            synchronized (oTPAuthenticator2) {
                oTPAuthenticator.wait();
                SessionCredential sessionCredential = session.getLocalCredential();
                if (sessionCredential == null) {
                    oTPAuthenticator.abort("Authentication Failed");
                } else {
                    bl = true;
                    Log.logEntry((int)7, (String)SASL_OTP, (String)("Wow, cool!!! " + session + " is valid for\n" + sessionCredential.toString()));
                }
            }
        }
        catch (Exception exception) {
            oTPAuthenticator.abort(exception.getMessage());
        }
        return session;
    }

    public static Session AuthenticateSASLOTPWithInit(Session session, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SASLException {
        boolean bl = false;
        SASLOTPProfile.convertHexToBytes(string5);
        string6 = string6.toLowerCase();
        if (!(OTPGenerator.validateSeed(string6) && OTPGenerator.validatePassphrase(string3) && OTPGenerator.validateSequence(string7))) {
            throw new SASLException("Unsuitable values for the parameters to init-hex");
        }
        SASLProfile.clearCredential(session, null);
        OTPAuthenticator oTPAuthenticator = SASLOTPProfile.instance().startAuthentication(string, string2, string3, string4, string5, string6, string7);
        Channel channel = null;
        String string8 = null;
        try {
            channel = session.startChannel(URI, false, null, (DataListener)oTPAuthenticator);
            string8 = channel.getStartData();
        }
        catch (BEEPException bEEPException) {
            oTPAuthenticator.abort(bEEPException.getMessage());
        }
        Blob blob = null;
        if (string8 != null && (blob = new Blob(string8)).getStatus().equals("abort")) {
            throw new SASLException(ERR_REJECTED);
        }
        oTPAuthenticator.started(channel);
        oTPAuthenticator.sendIdentity(string, string2);
        try {
            OTPAuthenticator oTPAuthenticator2 = oTPAuthenticator;
            synchronized (oTPAuthenticator2) {
                oTPAuthenticator.wait();
                SessionCredential sessionCredential = session.getLocalCredential();
                if (sessionCredential == null) {
                    oTPAuthenticator.abort("Authentication Failed");
                } else {
                    bl = true;
                    Log.logEntry((int)7, (String)SASL_OTP, (String)("Wow, cool!!! " + session + " is valid for\n" + sessionCredential.toString()));
                }
            }
        }
        catch (Exception exception) {
            oTPAuthenticator.abort(exception.getMessage());
        }
        return session;
    }

    static void printHex(byte[] byArray) {
        Log.logEntry((int)7, (String)SASL_OTP, (String)SASLOTPProfile.convertBytesToHex(byArray));
    }

    public static byte[] convertLongToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 7;
        while (n >= 0) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            --n;
        }
        return byArray;
    }

    protected long convertBytesToLong(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
            ++n;
        }
        return l;
    }

    public static long convertHexToLong(String string) throws SASLException {
        if (string.length() != 16) {
            throw new SASLException("Illegal hash" + string.length());
        }
        long l = 0L;
        l = Long.valueOf(string, 16);
        return l;
    }

    public static String convertBytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < 8) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] convertHexToBytes(String string) throws SASLException {
        byte[] byArray = new byte[8];
        if (string.length() != 16) {
            throw new SASLException("Illegal hash" + string.length());
        }
        int n = 0;
        while (n < 16) {
            byArray[n / 2] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
        }
        return byArray;
    }
}

