/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp.algorithm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.beepcore.beep.profile.sasl.InvalidParameterException;
import org.beepcore.beep.profile.sasl.otp.algorithm.Algorithm;

public abstract class AlgorithmImpl
implements Algorithm {
    private String internalAlgorithmName;

    public AlgorithmImpl(String string) {
        this.internalAlgorithmName = string;
    }

    public abstract String getName();

    public byte[] generateHash(String string) throws InvalidParameterException {
        return this.generateHash(string.getBytes());
    }

    public byte[] generateHash(byte[] byArray) throws InvalidParameterException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.internalAlgorithmName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(this.internalAlgorithmName + " hash algorithm not found");
        }
        return messageDigest.digest(byArray);
    }

    protected abstract byte[] foldHash(byte[] var1) throws InvalidParameterException;
}

