/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp.algorithm.sha1;

import org.beepcore.beep.profile.sasl.InvalidParameterException;
import org.beepcore.beep.profile.sasl.otp.algorithm.AlgorithmImpl;

public class SHA1
extends AlgorithmImpl {
    private static final String SHA1_INTERNAL = "SHA";
    private static final String SHA1_NAME = "otp-sha1";

    public SHA1() {
        super(SHA1_INTERNAL);
    }

    public String getName() {
        return SHA1.getAlgorithmName();
    }

    public static String getAlgorithmName() {
        return SHA1_NAME;
    }

    public byte[] generateHash(byte[] byArray) throws InvalidParameterException {
        if (byArray == null) {
            throw new InvalidParameterException();
        }
        byArray = super.generateHash(byArray);
        return this.foldHash(byArray);
    }

    protected byte[] foldHash(byte[] byArray) throws InvalidParameterException {
        if (byArray == null) {
            throw new InvalidParameterException();
        }
        int n = 0;
        while (n < 4) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ 0xFF & byArray[n + 8]);
            ++n;
        }
        int n3 = 4;
        while (n3 < 8) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] ^ 0xFF & byArray[n3 + 8]);
            ++n3;
        }
        int n5 = 0;
        while (n5 < 4) {
            int n6 = n5;
            byArray[n6] = (byte)(byArray[n6] ^ 0xFF & byArray[n5 + 16]);
            ++n5;
        }
        byte[] byArray2 = new byte[8];
        int n7 = 0;
        while (n7 < 4) {
            byArray2[3 - n7] = byArray[n7];
            byArray2[7 - n7] = byArray[n7 + 4];
            ++n7;
        }
        return byArray2;
    }
}

