/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.sasl.otp.database;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.beepcore.beep.profile.sasl.SASLException;
import org.beepcore.beep.profile.sasl.otp.database.UserDBNotFoundException;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabase;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabaseImpl;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabaseManager;
import org.beepcore.beep.util.Log;

public class UserDatabasePool
implements UserDatabaseManager {
    private Hashtable userpool = new Hashtable(4);

    public UserDatabase getUser(String string) throws SASLException {
        UserDatabase userDatabase;
        if (string == null) {
            throw new SASLException("Must supply a username to get an OTP DB");
        }
        if (this.userpool == null) {
            this.userpool = new Hashtable();
        }
        if ((userDatabase = (UserDatabase)this.userpool.get(string)) == null) {
            Properties properties = new Properties();
            try {
                Log.logEntry((int)7, (String)("Loading otp property file " + string + ".otp"));
                properties.load(new FileInputStream(string + ".otp"));
            }
            catch (IOException iOException) {
                Log.logEntry((int)3, (String)new String("User OTP database not found for user " + string));
                throw new UserDBNotFoundException(string);
            }
            try {
                userDatabase = new UserDatabaseImpl(properties.getProperty("OTP Algorithm"), properties.getProperty("OTP Last Hash"), properties.getProperty("OTP Seed"), properties.getProperty("OTP Authenticator"), Integer.parseInt(properties.getProperty("OTP Sequence")));
            }
            catch (Exception exception) {
                throw new SASLException("OTP DB for " + string + "is corrupted");
            }
            this.userpool.put(string, userDatabase);
            Log.logEntry((int)7, (String)((Hashtable)properties).toString());
            Log.logEntry((int)7, (String)("Stored otp settings for " + string));
        }
        Log.logEntry((int)7, (String)("Fetching User Database for " + string));
        return userDatabase;
    }

    private void addUser(String string, UserDatabase userDatabase) throws SASLException {
        this.userpool.put(string, userDatabase);
        this.updateUserDB(userDatabase);
    }

    public void addUser(String string, String string2, String string3, String string4, String string5) throws SASLException {
        UserDatabaseImpl userDatabaseImpl = new UserDatabaseImpl(string2, string3, string4, string, Integer.parseInt(string5));
        this.addUser(string, userDatabaseImpl);
    }

    public void updateUserDB(UserDatabase userDatabase) throws SASLException {
        try {
            Properties properties = new Properties();
            String string = userDatabase.getAuthenticator();
            Log.logEntry((int)7, (String)("Updating User DB on for=>" + string));
            properties.setProperty("OTP Authenticator", string);
            properties.setProperty("OTP Last Hash", userDatabase.getLastHashAsString());
            properties.setProperty("OTP Seed", userDatabase.getSeed());
            properties.setProperty("OTP Mechanism", "otp");
            properties.setProperty("OTP Algorithm", userDatabase.getAlgorithmName());
            properties.setProperty("OTP Sequence", Integer.toString(userDatabase.getSequence()));
            properties.store(new FileOutputStream(string + ".otp"), "OTP Properties Header");
        }
        catch (IOException iOException) {
            Log.logEntry((int)3, (Throwable)iOException);
            throw new SASLException(iOException.getMessage());
        }
    }

    public void removeUserDB(String string) throws SASLException {
    }

    public void populateUserDatabases() throws SASLException {
        try {
            Properties properties = new Properties();
            properties.setProperty("OTP Authenticator", "IW_User");
            properties.setProperty("OTP Last Hash", "7CD34C1040ADD14B");
            properties.setProperty("OTP Seed", "alpha1");
            properties.setProperty("OTP Mechanism", "otp");
            properties.setProperty("OTP Algorithm", "otp-md5");
            properties.setProperty("OTP Sequence", "1");
            properties.store(new FileOutputStream("IW_User.otp"), "OTP Properties Header");
            properties = new Properties();
            properties.setProperty("OTP Authenticator", "IW_User2");
            properties.setProperty("OTP Last Hash", "82AEB52D943774E4");
            properties.setProperty("OTP Seed", "correct");
            properties.setProperty("OTP Mechanism", "otp");
            properties.setProperty("OTP Algorithm", "otp-sha1");
            properties.setProperty("OTP Sequence", "1");
            properties.store(new FileOutputStream("IW_User2.otp"), "OTP Properties Header");
        }
        catch (IOException iOException) {
            Log.logEntry((int)3, (Throwable)iOException);
        }
    }
}

