/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.concurrent;

public class ReadWriteLock {
    private int m_numReadLocksHeld = 0;
    private int m_numWaitingForWrite = 0;
    private Object m_lock = new Object();

    public void aquireRead() throws InterruptedException {
        Object object = this.m_lock;
        synchronized (object) {
            while (this.m_numReadLocksHeld == -1 || this.m_numWaitingForWrite != 0) {
                this.m_lock.wait();
            }
            ++this.m_numReadLocksHeld;
        }
    }

    public void aquireWrite() throws InterruptedException {
        Object object = this.m_lock;
        synchronized (object) {
            ++this.m_numWaitingForWrite;
            try {
                while (this.m_numReadLocksHeld != 0) {
                    this.m_lock.wait();
                }
                this.m_numReadLocksHeld = -1;
            }
            finally {
                Object var4_2 = null;
                --this.m_numWaitingForWrite;
            }
        }
    }

    public void release() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_numReadLocksHeld == 0) {
                throw new IllegalStateException("Attempted to release an unlocked ReadWriteLock.");
            }
            this.m_numReadLocksHeld = this.m_numReadLocksHeld == -1 ? 0 : --this.m_numReadLocksHeld;
            this.m_lock.notifyAll();
        }
    }

    public boolean tryAquireRead() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_numReadLocksHeld != -1 && this.m_numWaitingForWrite == 0) {
                ++this.m_numReadLocksHeld;
                return true;
            }
            return false;
        }
    }

    public boolean tryAquireWrite() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_numReadLocksHeld == 0) {
                this.m_numReadLocksHeld = -1;
                return true;
            }
            return false;
        }
    }
}

