/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.avalon.excalibur.datasource.JdbcConnection;
import org.apache.avalon.excalibur.datasource.NoValidConnectionException;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class JdbcConnectionFactory
extends AbstractLogEnabled
implements ObjectFactory {
    private static final String DEFAULT_KEEPALIVE = "SELECT 1";
    private static final String ORACLE_KEEPALIVE = "SELECT 1 FROM DUAL";
    private final String m_dburl;
    private final String m_username;
    private final String m_password;
    private final boolean m_autoCommit;
    private final String m_keepAlive;
    private String m_connectionClass;
    private static /* synthetic */ Class class$Ljava$sql$Connection;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lorg$apache$avalon$excalibur$datasource$JdbcConnection;

    public Object newInstance() throws Exception {
        JdbcConnection jdbcConnection = null;
        Connection connection = null;
        connection = this.m_username == null ? DriverManager.getConnection(this.m_dburl) : DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password);
        if (this.m_connectionClass == null) {
            try {
                Method meth = connection.getClass().getMethod("getHoldability", new Class[0]);
                this.m_connectionClass = "org.apache.avalon.excalibur.datasource.Jdbc3Connection";
            }
            catch (Exception e) {
                this.m_connectionClass = "org.apache.avalon.excalibur.datasource.JdbcConnection";
            }
        }
        if (this.m_connectionClass != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.m_connectionClass);
                Class[] paramTypes = new Class[]{class$Ljava$sql$Connection != null ? class$Ljava$sql$Connection : (class$Ljava$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JdbcConnectionFactory.class$("java.lang.String"))};
                Object[] params = new Object[]{connection, this.m_keepAlive};
                Constructor<?> constructor = clazz.getConstructor(paramTypes);
                jdbcConnection = (JdbcConnection)constructor.newInstance(params);
            }
            catch (Exception e) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.m_connectionClass);
                    Class[] paramTypes = new Class[]{class$Ljava$sql$Connection != null ? class$Ljava$sql$Connection : (class$Ljava$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")), Boolean.TYPE};
                    Object[] params = new Object[]{connection, new Boolean(this.m_keepAlive.equalsIgnoreCase(ORACLE_KEEPALIVE))};
                    Constructor<?> constructor = clazz.getConstructor(paramTypes);
                    jdbcConnection = (JdbcConnection)constructor.newInstance(params);
                }
                catch (Exception ie) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Exception in JdbcConnectionFactory.newInstance:", (Throwable)ie);
                    }
                    throw new NoValidConnectionException(ie.getMessage());
                }
            }
        } else {
            throw new NoValidConnectionException("No valid JdbcConnection class available");
        }
        jdbcConnection.enableLogging(this.getLogger());
        if (jdbcConnection.getAutoCommit() != this.m_autoCommit) {
            jdbcConnection.setAutoCommit(this.m_autoCommit);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JdbcConnection object created");
        }
        return jdbcConnection;
    }

    public Class getCreatedClass() {
        return class$Lorg$apache$avalon$excalibur$datasource$JdbcConnection != null ? class$Lorg$apache$avalon$excalibur$datasource$JdbcConnection : (class$Lorg$apache$avalon$excalibur$datasource$JdbcConnection = JdbcConnectionFactory.class$("org.apache.avalon.excalibur.datasource.JdbcConnection"));
    }

    public void decommission(Object object) throws Exception {
        if (object instanceof JdbcConnection) {
            ((JdbcConnection)object).dispose();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb) {
        this(url, username, password, autoCommit, oradb, null);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb, String connectionClass) {
        this(url, username, password, autoCommit, oradb ? ORACLE_KEEPALIVE : DEFAULT_KEEPALIVE, connectionClass);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, String keepAlive, String connectionClass) {
        this.m_dburl = url;
        this.m_username = username;
        this.m_password = password;
        this.m_autoCommit = autoCommit;
        this.m_keepAlive = keepAlive;
        this.m_connectionClass = connectionClass;
    }
}

