/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class DefaultLogKitManager
extends AbstractLogEnabled
implements LogKitManager,
Loggable,
Contextualizable,
Configurable {
    private final Map m_loggers = new HashMap();
    private Context m_context;
    private Hierarchy m_hierarchy;
    private String m_prefix;

    public void setLogger(Logger logger) {
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    public final Logger getLogger(String categoryName) {
        Logger logger = (Logger)this.m_loggers.get(categoryName);
        if (logger != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Logger for category " + categoryName + " returned");
            }
            return logger;
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Logger for category " + categoryName + " not correctly defined. New Logger created and returned");
        }
        return this.m_hierarchy.getLoggerFor(categoryName);
    }

    public Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration factories = configuration.getChild("factories");
        LogTargetFactoryManager targetFactoryManager = this.setupTargetFactoryManager(factories);
        Configuration targets = configuration.getChild("targets");
        LogTargetManager targetManager = this.setupTargetManager(targets, targetFactoryManager);
        Configuration categories = configuration.getChild("categories");
        Configuration[] category = categories.getChildren("category");
        this.setupLoggers(targetManager, this.m_prefix, category);
    }

    private final LogTargetFactoryManager setupTargetFactoryManager(Configuration configuration) throws ConfigurationException {
        DefaultLogTargetFactoryManager targetFactoryManager = new DefaultLogTargetFactoryManager();
        if (targetFactoryManager instanceof LogEnabled) {
            targetFactoryManager.enableLogging(this.getLogger());
        }
        if (targetFactoryManager instanceof Contextualizable) {
            try {
                targetFactoryManager.contextualize(this.m_context);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("cannot contextualize default factory manager", (Throwable)ce);
            }
        }
        targetFactoryManager.configure(configuration);
        return targetFactoryManager;
    }

    private final LogTargetManager setupTargetManager(Configuration configuration, LogTargetFactoryManager targetFactoryManager) throws ConfigurationException {
        DefaultLogTargetManager targetManager = new DefaultLogTargetManager();
        if (targetManager instanceof LogEnabled) {
            targetManager.enableLogging(this.getLogger());
        }
        if (targetManager instanceof Contextualizable) {
            try {
                targetManager.contextualize(this.m_context);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("cannot contextualize factory manager", (Throwable)ce);
            }
        }
        if (targetManager instanceof LogTargetFactoryManageable) {
            targetManager.setLogTargetFactoryManager(targetFactoryManager);
        }
        if (targetManager instanceof Configurable) {
            targetManager.configure(configuration);
        }
        return targetManager;
    }

    private final void setupLoggers(LogTargetManager targetManager, String parentCategory, Configuration[] categories) throws ConfigurationException {
        int i = 0;
        while (i < categories.length) {
            String full_category;
            String category = categories[i].getAttribute("name");
            String loglevel = categories[i].getAttribute("log-level").toUpperCase();
            Configuration[] targets = categories[i].getChildren("log-target");
            LogTarget[] log_targets = new LogTarget[targets.length];
            int j2 = 0;
            while (j2 < targets.length) {
                String id = targets[j2].getAttribute("id-ref");
                log_targets[j2] = targetManager.getLogTarget(id);
                ++j2;
            }
            if ("".equals(category) && log_targets.length > 0) {
                this.m_hierarchy.setDefaultPriority(Priority.getPriorityForName((String)loglevel));
                this.m_hierarchy.setDefaultLogTargets(log_targets);
            }
            if (parentCategory == null) {
                String j2 = category;
            } else {
                full_category = parentCategory + "." + category;
            }
            Logger logger = this.m_hierarchy.getLoggerFor(full_category);
            this.m_loggers.put(full_category, logger);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added logger for category " + full_category);
            }
            logger.setPriority(Priority.getPriorityForName((String)loglevel));
            logger.setLogTargets(log_targets);
            Configuration[] sub_categories = categories[i].getChildren("category");
            if (sub_categories != null) {
                this.setupLoggers(targetManager, full_category, sub_categories);
            }
            ++i;
        }
    }

    public DefaultLogKitManager() {
        this(new Hierarchy());
    }

    public DefaultLogKitManager(Hierarchy hierarchy) {
        this(null, hierarchy);
    }

    public DefaultLogKitManager(String prefix) {
        this(prefix, new Hierarchy());
    }

    public DefaultLogKitManager(String prefix, Hierarchy hierarchy) {
        this.m_prefix = prefix;
        this.m_hierarchy = hierarchy;
    }
}

