/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.format.XMLFormatter;

public class FormatterFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    public Formatter createFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        if ("xml".equals(type)) {
            return new XMLFormatter();
        }
        return new PatternFormatter(format);
    }
}

