/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.naming.memory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.avalon.excalibur.naming.AbstractLocalContext;
import org.apache.avalon.excalibur.naming.Namespace;
import org.apache.avalon.excalibur.naming.memory.MemoryNamingEnumeration;

public class MemoryContext
extends AbstractLocalContext {
    private Hashtable m_bindings;

    protected Context newContext() throws NamingException {
        return new MemoryContext(this.getNamespace(), this.getRawEnvironment(), this.getParent());
    }

    protected Context cloneContext() throws NamingException {
        return new MemoryContext(this.getNamespace(), this.getRawEnvironment(), this.getParent(), this.m_bindings);
    }

    protected void doLocalBind(Name name, Object object) throws NamingException {
        this.m_bindings.put(name.get(0), object);
    }

    protected NamingEnumeration doLocalList() throws NamingException {
        return new MemoryNamingEnumeration(this, this.getNamespace(), this.m_bindings, false);
    }

    protected NamingEnumeration doLocalListBindings() throws NamingException {
        return new MemoryNamingEnumeration(this, this.getNamespace(), this.m_bindings, true);
    }

    protected Object doLocalLookup(Name name) throws NamingException {
        Object object = this.m_bindings.get(name.get(0));
        if (object == null) {
            throw new NameNotFoundException(name.get(0));
        }
        return object;
    }

    protected void doLocalUnbind(Name name) throws NamingException {
        this.m_bindings.remove(name.get(0));
    }

    protected MemoryContext(Namespace namespace, Hashtable environment, Context parent, Hashtable bindings) {
        super(namespace, environment, parent);
        this.m_bindings = bindings;
    }

    public MemoryContext(Namespace namespace, Hashtable environment, Context parent) {
        this(namespace, environment, parent, new Hashtable(11));
    }
}

