/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.StringTokenizer;

public final class Main {
    private static final String MAIN_CLASS = "org.apache.avalon.phoenix.frontends.CLIMain";
    private static final String MAIN_JAR = "phoenix-engine.jar";
    private static final String LOADER_JAR = "phoenix-loader.jar";

    public static final void main(String[] args) throws Exception {
        try {
            Policy.setPolicy(new FreeNEasyPolicy());
            File mainJar = Main.findEngineJar();
            URL archive = mainJar.toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{archive});
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = classLoader.loadClass(MAIN_CLASS);
            Method method = clazz.getMethod("main", args.getClass());
            Object instance = clazz.newInstance();
            method.invoke(instance, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final File findEngineJar() throws Exception {
        String phoenixHome = System.getProperty("phoenix.home", null);
        File loaderDir = null;
        if (phoenixHome != null) {
            String filename = phoenixHome + File.separator + "bin" + File.separator + MAIN_JAR;
            return new File(filename);
        }
        loaderDir = Main.findLoaderDir();
        phoenixHome = loaderDir.getAbsoluteFile().getParentFile() + File.separator;
        System.setProperty("phoenix.home", phoenixHome);
        return new File(loaderDir, MAIN_JAR);
    }

    private static final File findLoaderDir() throws Exception {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (!element.endsWith(LOADER_JAR)) continue;
            File file = new File(element).getCanonicalFile();
            file = file.getParentFile();
            return file;
        }
        throw new Exception("Unable to locate " + LOADER_JAR + " in classpath");
    }

    private static class FreeNEasyPolicy
    extends Policy {
        public PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }

        public void refresh() {
        }

        FreeNEasyPolicy() {
        }
    }
}

