/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.avalon.cornerstone.blocks.connection.ConnectionRunner;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

class Connection
extends AbstractLogEnabled
implements Component,
Runnable {
    private final ServerSocket m_serverSocket;
    private final ConnectionHandlerFactory m_handlerFactory;
    private final ThreadPool m_threadPool;
    private final Vector m_runners = new Vector();
    private Thread m_thread;

    public void dispose() throws Exception {
        Connection connection = this;
        synchronized (connection) {
            if (this.m_thread != null) {
                Thread thread = this.m_thread;
                this.m_thread = null;
                thread.interrupt();
                this.wait();
            }
        }
        Iterator runners = ((AbstractList)this.m_runners).iterator();
        while (runners.hasNext()) {
            ConnectionRunner runner = (ConnectionRunner)runners.next();
            runner.dispose();
        }
        this.m_runners.clear();
    }

    public void run() {
        this.m_thread = Thread.currentThread();
        while (this.m_thread != null && !Thread.interrupted()) {
            try {
                Socket socket = this.m_serverSocket.accept();
                ConnectionHandler handler = this.m_handlerFactory.createConnectionHandler();
                ConnectionRunner runner = new ConnectionRunner(socket, this.m_runners, handler);
                this.setupLogger(runner);
                this.m_threadPool.execute((Runnable)runner);
            }
            catch (InterruptedIOException iioe) {
            }
            catch (IOException ioe) {
                this.getLogger().error("Exception accepting connection", (Throwable)ioe);
            }
            catch (Exception e) {
                this.getLogger().error("Exception executing runner", (Throwable)e);
            }
        }
        Connection connection = this;
        synchronized (connection) {
            this.notifyAll();
            this.m_thread = null;
        }
    }

    public Connection(ServerSocket serverSocket, ConnectionHandlerFactory handlerFactory, ThreadPool threadPool) {
        this.m_serverSocket = serverSocket;
        this.m_handlerFactory = handlerFactory;
        this.m_threadPool = threadPool;
    }
}

