/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

class ConnectionRunner
extends AbstractLogEnabled
implements Runnable,
Component {
    private Socket m_socket;
    private Thread m_thread;
    private List m_runners;
    private ConnectionHandler m_handler;

    public void dispose() throws Exception {
        if (this.m_thread != null) {
            this.m_thread.interrupt();
            this.m_thread = null;
            ConnectionRunner connectionRunner = this;
            synchronized (connectionRunner) {
                this.wait();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        this.m_thread = Thread.currentThread();
        this.m_runners.add(this);
        this.getLogger().debug("Starting connection on " + this.m_socket);
        this.m_handler.handleConnection(this.m_socket);
        this.getLogger().debug("Ending connection on " + this.m_socket);
        Object var2_1 = null;
        try {
            this.m_socket.close();
        }
        catch (IOException ioe) {
            this.getLogger().warn("Error shutting down connection", (Throwable)ioe);
        }
        this.m_thread = null;
        this.m_runners.remove(this);
        ConnectionRunner connectionRunner = this;
        synchronized (connectionRunner) {
            this.notifyAll();
        }
        {
            catch (Exception e) {
                this.getLogger().warn("Error handling connection", (Throwable)e);
                Object var2_2 = null;
                try {
                    this.m_socket.close();
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Error shutting down connection", (Throwable)ioe);
                }
                this.m_thread = null;
                this.m_runners.remove(this);
                ConnectionRunner connectionRunner2 = this;
                synchronized (connectionRunner2) {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                this.m_socket.close();
            }
            catch (IOException ioe) {
                this.getLogger().warn("Error shutting down connection", (Throwable)ioe);
            }
            this.m_thread = null;
            this.m_runners.remove(this);
            ConnectionRunner connectionRunner3 = this;
            synchronized (connectionRunner3) {
                this.notifyAll();
            }
            throw throwable;
        }
    }

    ConnectionRunner(Socket socket, List runners, ConnectionHandler handler) {
        this.m_socket = socket;
        this.m_runners = runners;
        this.m_handler = handler;
    }
}

