/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.net.ServerSocket;
import java.util.HashMap;
import org.apache.avalon.cornerstone.blocks.connection.Connection;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.cornerstone.services.connection.ConnectionManager;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;

public class DefaultConnectionManager
extends AbstractLogEnabled
implements Block,
ConnectionManager,
Composable,
Disposable {
    private HashMap m_connections = new HashMap();
    private ThreadManager m_threadManager;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_threadManager = (ThreadManager)componentManager.lookup("org.apache.avalon.cornerstone.services.threads.ThreadManager");
    }

    public void dispose() {
        String[] names = this.m_connections.keySet().toArray(new String[0]);
        int i = 0;
        while (i < names.length) {
            try {
                this.disconnect(names[i]);
            }
            catch (Exception e) {
                this.getLogger().warn("Error disconnecting " + names[i], (Throwable)e);
            }
            ++i;
        }
    }

    public void connect(String name, ServerSocket socket, ConnectionHandlerFactory handlerFactory, ThreadPool threadPool) throws Exception {
        if (this.m_connections.get(name) != null) {
            throw new IllegalArgumentException("Connection already exists with name " + name);
        }
        if (socket.getSoTimeout() == 0) {
            socket.setSoTimeout(500);
        }
        Connection runner = new Connection(socket, handlerFactory, threadPool);
        this.setupLogger(runner);
        this.m_connections.put(name, runner);
        threadPool.execute((Runnable)runner);
    }

    public void connect(String name, ServerSocket socket, ConnectionHandlerFactory handlerFactory) throws Exception {
        this.connect(name, socket, handlerFactory, this.m_threadManager.getDefaultThreadPool());
    }

    public void disconnect(String name) throws Exception {
        this.disconnect(name, false);
    }

    public void disconnect(String name, boolean tearDown) throws Exception {
        Connection connection = (Connection)this.m_connections.remove(name);
        if (connection == null) {
            throw new IllegalArgumentException("No such connection with name " + name);
        }
        connection.dispose();
    }
}

