/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.datasource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.cornerstone.services.datasource.DataSourceSelector;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block;

public class DefaultDataSourceSelector
extends AbstractLoggable
implements DataSourceSelector,
Block,
Configurable,
Initializable,
Disposable {
    private Configuration m_configuration;
    private Map m_dataSources;

    public void configure(Configuration configuration) {
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        this.m_dataSources = new HashMap();
        Configuration[] dataSourceConfs = this.m_configuration.getChild("data-sources").getChildren("data-source");
        int i = 0;
        while (i < dataSourceConfs.length) {
            Configuration dataSourceConf = dataSourceConfs[i];
            String name = dataSourceConf.getAttribute("name");
            String clazz = dataSourceConf.getAttribute("class");
            String driver = dataSourceConf.getChild("driver", true).getValue("");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            DataSourceComponent component = null;
            if (classLoader == null) {
                if (!"".equals(driver)) {
                    Class.forName(driver);
                }
                component = (DataSourceComponent)Class.forName(clazz).newInstance();
            } else {
                if (!"".equals(driver)) {
                    classLoader.loadClass(driver);
                }
                component = (DataSourceComponent)classLoader.loadClass(clazz).newInstance();
            }
            if (component instanceof LogEnabled) {
                ((LogEnabled)component).enableLogging((Logger)new LogKitLogger(this.getLogger().getChildLogger(name)));
            } else if (component instanceof Loggable) {
                ((Loggable)component).setLogger(this.getLogger().getChildLogger(name));
            }
            component.configure(dataSourceConf);
            this.m_dataSources.put(name, component);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("DataSource " + name + " ready");
            }
            ++i;
        }
    }

    public void dispose() {
        Iterator keys = this.m_dataSources.keySet().iterator();
        while (keys.hasNext()) {
            DataSourceComponent dsc = (DataSourceComponent)this.m_dataSources.get(keys.next());
            if (!(dsc instanceof Disposable)) continue;
            ((Disposable)dsc).dispose();
        }
    }

    public boolean hasComponent(Object hint) {
        return this.m_dataSources.containsKey(hint);
    }

    public Component select(Object hint) throws ComponentException {
        Component component = (Component)this.m_dataSources.get(hint);
        if (component == null) {
            throw new ComponentException("Unable to provide DataSourceComponent for " + hint);
        }
        return component;
    }

    public void release(Component component) {
    }
}

